/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Apache2ApplicationPropertiesMap.java 9171 2011-10-13 14:30:56Z richardd $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.agent.remote.discovery.application.apache2;

import java.util.ArrayList;
import java.util.List;

import org.ow2.jasmine.agent.common.discovery.ApplicationProperty;

/**
 * Utility class to manage properties map for apache2
 * 
 * @author Julien Vey
 */
public class Apache2ApplicationPropertiesMap {

    /**
     * the listening port key
     */
    public static final String LISTENING_PORT_KEY = "Listening port";

    /**
     * the listening address key
     */
    public static final String LISTENING_ADDRESS = "Listening address";

    /**
     * the listening adress of apache
     */
    String listeningAddress;

    /**
     * the listening port of apache
     */
    int listeningPort;

    /**
     * Default constructor with no parameters
     */
    public Apache2ApplicationPropertiesMap() {
    }

    /**
     * Constructor with a map, will fill the corresponding attributes
     * 
     * @param props
     */
    public Apache2ApplicationPropertiesMap(List<ApplicationProperty> props) {

        setListeningPort(Integer.parseInt(getPropFromList(LISTENING_PORT_KEY, props)));
        setListeningAddress(getPropFromList(LISTENING_ADDRESS, props));
    }

    /**
     * Get a property from the list of properties
     * 
     * @param key
     *            the key of the property
     * @param props
     *            the list of properties
     * @return the property value found
     */
    private String getPropFromList(String key, List<ApplicationProperty> props) {
        for (ApplicationProperty prop : props) {
            if (prop.getPropertyName().equals(key)) {
                return prop.getPropertyValue();
            }
        }
        return null;
    }

    /***
     * Get the properties Map
     * 
     * @return the map of properties
     */
    public List<ApplicationProperty> getPropertiesList() {
        List<ApplicationProperty> props = new ArrayList<ApplicationProperty>();
        props.add(new ApplicationProperty(LISTENING_PORT_KEY, String.valueOf(listeningPort)));
        props.add(new ApplicationProperty(LISTENING_ADDRESS, listeningAddress));

        return props;

    }

    /**
     * @return the listeningPort
     */
    public int getListeningPort() {
        return listeningPort;
    }

    /**
     * @param listeningPort
     *            the listeningPort to set
     */
    public void setListeningPort(int listeningPort) {
        this.listeningPort = listeningPort;
    }

    /**
     * @return the listeningAddress
     */
    public String getListeningAddress() {
        return listeningAddress;
    }

    /**
     * @param listeningAddress
     *            the listeningAddress to set
     */
    public void setListeningAddress(String listeningAddress) {
        this.listeningAddress = listeningAddress;
    }
}
