/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DiscoveryRegistrer.java 9171 2011-10-13 14:30:56Z richardd $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.agent.remote.discovery;

import java.io.File;
import java.util.List;
import java.util.UUID;

import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.ow2.jasmine.agent.common.discovery.AgentDiscoveryService;
import org.ow2.jasmine.agent.common.discovery.SystemProperties;
import org.ow2.jasmine.agent.common.utils.Utilities;
import org.ow2.jasmine.agent.remote.discovery.system.SystemDiscovery;
import org.ow2.jonas.lib.bootstrap.JProp;

/**
 * Provider of the DiscoveryService on the agent
 * 
 * @author Julien Vey
 */
@Component(name = "JASMINe Agent Discovery Registrer", propagation = true)
@Provides()
public class DiscoveryRegistrer implements AgentDiscoveryService {

    /**
     * Unique Id of the agent. Will be use to identify the services corresponding to this agent
     */
    @ServiceProperty()
    public UUID id = generateAgentId();

    /**
     * static agent ID
     */
    public static UUID agentId = null;

    /**
     * if not already done, generate the id of the agent, else return the id already generated
     * 
     * @return the id of the agent
     */
    public UUID generateAgentId() {
        File conf = new File(JProp.getJonasBase(), "conf");
        File idFile = new File(conf, "agent.id");
        if (idFile.exists()) {
            List<String> list = Utilities.readFile(idFile);
            agentId = UUID.fromString(list.get(0));
        } else {
            agentId = UUID.randomUUID();
            Utilities.writeInFile(agentId.toString(), idFile);
        }
        return agentId;
    }

    /**
     * {@inheritDoc}
     */
    public String getId() {
        return staticGetId().toString();
    }

    /**
     * get the agent ID
     * 
     * @return the static agent ID
     */
    public static UUID staticGetId() {
        return agentId;
    }

    /**
     * {@inheritDoc}
     */
    public SystemProperties getSystemProperties() {
        return new SystemDiscovery().getSystemProperties();
    }

}
