/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: AgentEvent.java 9171 2011-10-13 14:30:56Z richardd $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.agent.server.event;

import java.io.Serializable;

import org.ow2.jasmine.agent.server.Agent;

/**
 * An AgentEvent is a description a Agent modification with the agent concerned an the type of the modification
 * 
 * @author Julien Vey
 */
public class AgentEvent implements Serializable {

    /**
     * serial version UID
     */
    private static final long serialVersionUID = 1602925346884551471L;

    /**
     * The type of the AgentEvent
     */
    private AgentEventType type;

    /**
     * The agent concerned
     */
    private Agent agent;

    /**
     * @return the type
     */
    public int getType() {
        return type.ordinal();
    }

    /**
     * @param type
     *            the type to set
     */
    public void setType(int type) {
        this.type = AgentEventType.values()[type];
    }

    /**
     * @return the agent
     */
    public Agent getAgent() {
        return agent;
    }

    /**
     * @param agent
     *            the agent to set
     */
    public void setAgent(Agent agent) {
        this.agent = agent;
    }

}
