/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: GroupsManagerImpl.java 9171 2011-10-13 14:30:56Z richardd $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.agent.server.groups;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 * Singleton which implements the GroupsManager interface
 * 
 * @author Julien Vey
 */
public class GroupsManagerImpl implements GroupsManager {

    /**
     * the unique instance
     */
    private static GroupsManagerImpl instance;

    /**
     * the list of groups
     */
    private List<Group> groupList;

    /**
     * private constructor
     */
    private GroupsManagerImpl() {
        groupList = new ArrayList<Group>();
    }

    /**
     * Get the unique instance
     * 
     * @return the unique instance
     */
    public static GroupsManagerImpl getInstance() {
        if (instance == null) {
            instance = new GroupsManagerImpl();
        }
        return instance;
    }

    /**
     * @return the groupList
     */
    public List<Group> getGroupList() {
        return getInstance().groupList;
    }

    /*
     * (non-Javadoc)
     * @see org.ow2.jasmine.agent.server.groups.GroupsManager#addGroup(org.ow2.jasmine.agent.server.groups.Group)
     */
    public void addGroup(Group g) {
        if (g.getId() == null) {
            g.setId(UUID.randomUUID().toString());
        }
        getInstance().groupList.add(g);
    }

    /**
     * @param groupList
     *            the groupList to set
     */
    public void setGroupList(List<Group> groupList) {
        getInstance().groupList = groupList;
    }

    /*
     * (non-Javadoc)
     * @see org.ow2.jasmine.agent.server.groups.GroupsManager#removeGroup(org.ow2.jasmine.agent.server.groups.Group)
     */
    public void removeGroup(Group g) {
        getInstance().groupList.remove(getInstance().getGroupFromID(g.getId()));
    }

    /**
     * Get a group from its ID
     * 
     * @param id
     *            the ID of the group
     * @return the group whose ID is id
     */
    public Group getGroupFromID(String id) {
        for (Group g : getInstance().groupList) {
            if (g.getId().equals(id)) {
                return g;
            }
        }
        return null;
    }

    /*
     * (non-Javadoc)
     * @see org.ow2.jasmine.agent.server.groups.GroupsManager#updateGroup(org.ow2.jasmine.agent.server.groups.Group)
     */
    public void updateGroup(Group g) {
        Group inlist = getInstance().getGroupFromID(g.getId());
        inlist.setApplicationList(g.getApplicationList());
        inlist.setColor(g.getColor());
        inlist.setName(g.getName());
    }

}
