/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: GroupEvent.java 9171 2011-10-13 14:30:56Z richardd $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.agent.server.groups.event;

import java.io.Serializable;

import org.ow2.jasmine.agent.server.groups.Group;

/**
 * A GroupEvent is a notification of a group modification which includes the group itself and the type of the
 * modification
 * 
 * @author Julien Vey
 */
public class GroupEvent implements Serializable {

    /**
     * serial version UID
     */
    private static final long serialVersionUID = -2620184549344716095L;

    /**
     * The group
     */
    private Group group;

    /**
     * The type of the event
     */
    private GroupEventType type;

    /**
     * @return the group
     */
    public Group getGroup() {
        return group;
    }

    /**
     * @param group
     *            the group to set
     */
    public void setGroup(Group group) {
        this.group = group;
    }

    /**
     * @return the type
     */
    public int getType() {
        return type.ordinal();
    }

    /**
     * @param type
     *            the type to set
     */
    public void setType(int type) {
        this.type = GroupEventType.values()[type];
    }

}
