/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Deployer.java 9171 2011-10-13 14:30:56Z richardd $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.agent.utils.deployer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;

import javax.ejb.Remote;
import javax.ejb.Stateless;

import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Validate;

import org.objectweb.fdf.components.fdf.lib.runnable.Launcher;

/**
 * FDF Deployer
 * 
 * @author Julien Vey
 */
@Component(name = "JASMINe Agent Deployer")
@Stateless(mappedName = "agent/deployer")
@Remote(IDeployer.class)
@Provides
public class Deployer implements IDeployer {

    /*
     * (non-Javadoc)
     * @see org.ow2.jasmine.agent.utils.deployer.IDeployer#deploy(org.ow2.jasmine.agent.utils.deployer.Deployment)
     */
    public void deploy(Deployment deployment) {
        System.out.println("Deploying");
        System.setProperty("fractal.provider", "org.objectweb.fractal.julia.Julia");
        System.setProperty("julia.config", "fdf-julia.cfg");
        System.out.println("Invoking main");

        // String[] args2 = {
        // "-fractal",
        // Launcher.class.getName() + "(" + "/home/veyj/Téléchargements/FDF-all-2.1/examples/jonas/JOnAS.fdf" + "," +
        // "install"
        // + ",,,,,)", "r" };

        try {
            String[] args2 = {
                    "-fractal",
                    Launcher.class.getName() + "(" + generateDescription(deployment).getAbsolutePath() + ","
                            + "install" + ",,,,,)", "r" };
            org.objectweb.fractal.adl.Launcher.main(args2);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    // TODO Remove !!!! Only here for test
    // @Validate
    // public void test() {
    // System.out.println("Hello World");
    // Deployment d = new Deployment(
    // "129.183.128.233",
    // "veyj",
    // "passpass",
    // "/home/veyj/rsa.ssh",
    // TransfertProtocol.JSCP,
    // CommandProtocol.OPEN_SSH,
    // Shell.SH,
    // new File("/home/veyj/workspace/agent/assemblies/agent/target/agent.assemblies.agent-0.0.1-SNAPSHOT.zip"),
    // "/home/veyj/target/JOnAS", "myAgent", 9099, "agentDomanin");
    // deploy(d);
    // }

    /**
     * generate the description file used by FDF
     * 
     * @param d
     *            deployement
     * @return
     */
    public File generateDescription(Deployment d) {
        File f = new File("JOnAS.fdf");

        try {
            FileWriter fw = new FileWriter(f);
            BufferedWriter bw = new BufferedWriter(fw);
            PrintWriter outputFile = new PrintWriter(bw);

            outputFile.println("");
            outputFile.println("JOnAS {");
            outputFile.println("\tHosts = INTERNET.NETWORK {");
            outputFile.println("\t\thost1 = INTERNET.HOST {");
            outputFile.println("\t\t\thostname = INTERNET.HOSTNAME(" + d.getIpAddress() + ");");
            outputFile.println("\t\t\tuser = INTERNET.USER(" + d.getUsername() + "," + d.getPassword() + ","
                    + "" + ");");
            outputFile.println("\t\t\ttransfer = TRANSFER." + d.getTransfert() + ";");
            outputFile.println("\t\t\tprotocol = PROTOCOL." + d.getCommand() + ";");
            outputFile.println("\t\t\tshell    = SHELL." + d.getShell() + ";");
            outputFile.println("\t\t}");
            outputFile.println("\t}");
            outputFile.println("\tJOnAS-Servers {");
            outputFile.println("\t\tjonas-host1 = JOnAS.SERVER {");
            outputFile.println("\t\t\tarchive    = JOnAS.ARCHIVE(" + d.getAgentArchive() + ");");
            outputFile.println("\t\t\troot       = JOnAS.ROOT(" + d.getTargetJonasRoot() + ");");
            outputFile.println("\t\t\thost       = Hosts/host1;");
            outputFile.println("\t\t\tproperties {");
            outputFile.println("\t\t\t\thttp-port = HTTP.PORT(" + d.getTargetHTTPPort() + ");");
            // outputFile.println("name = JOnAS.NAME(" + d.getTargetJonasName() + ");");
            // outputFile.println("domain = JOnAS.DOMAIN(" + d.getTargetJonasDomain() + ");");
            outputFile.println("\t\t\t}");
            outputFile.println("\t\t}");
            outputFile.println("\t}");
            outputFile.println("}");
            outputFile.close();
        } catch (Exception e) {
            e.printStackTrace();
        }

        return f;
    }

}
