/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Deployment.java 9171 2011-10-13 14:30:56Z richardd $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.agent.utils.deployer;

import java.io.File;
import java.io.Serializable;

/**
 * Deployment Description Class
 * 
 * @author Julien Vey
 */
public class Deployment implements Serializable{

    /**
     * 
     */
    private static final long serialVersionUID = 8840541923653075872L;

    /**
     * IP Address
     */
    private String ipAddress;

    /**
     * Username
     */
    private String username;

    /**
     * Password
     */
    private String password;

    /**
     * Private SSH Key
     */
    private String privateKey;

    /**
     * Transfert Protocol
     */
    private TransfertProtocol transfert;

    /**
     * Command Protocol 
     */
    private CommandProtocol command;

    /**
     * Shell
     */
    private Shell shell;

    /**
     * Agent Archive location
     */
    private File agentArchive;

    /**
     * Target JOnAS Root
     */
    private String targetJonasRoot;

    /**
     * Target JOnAS Name
     */
    private String targetJonasName;

    /**
     * Target HTTP Port
     */
    private int targetHTTPPort;

    /**
     * Target JOnAS Domain
     */
    private String targetJonasDomain;

    /**
     * @param ipAddress
     * @param username
     * @param password
     * @param privateKey
     * @param transfert
     * @param command
     * @param shell
     * @param agentArchive
     * @param targetJonasRoot
     * @param targetJonasName
     * @param targetHTTPPort
     * @param targetJonasDomain
     */
    public Deployment(String ipAddress, String username, String password, String privateKey,
            TransfertProtocol transfert, CommandProtocol command, Shell shell, File agentArchive,
            String targetJonasRoot, String targetJonasName, int targetHTTPPort, String targetJonasDomain) {
        this.ipAddress = ipAddress;
        this.username = username;
        this.password = password;
        this.privateKey = privateKey;
        this.transfert = transfert;
        this.command = command;
        this.shell = shell;
        this.agentArchive = agentArchive;
        this.targetJonasRoot = targetJonasRoot;
        this.targetJonasName = targetJonasName;
        this.targetHTTPPort = targetHTTPPort;
        this.targetJonasDomain = targetJonasDomain;
    }

    /**
     * @return the ipAddress
     */
    public String getIpAddress() {
        return ipAddress;
    }

    /**
     * @param ipAddress
     *            the ipAddress to set
     */
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    /**
     * @return the username
     */
    public String getUsername() {
        return username;
    }

    /**
     * @param username
     *            the username to set
     */
    public void setUsername(String username) {
        this.username = username;
    }

    /**
     * @return the password
     */
    public String getPassword() {
        return password;
    }

    /**
     * @param password
     *            the password to set
     */
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * @return the privateKey
     */
    public String getPrivateKey() {
        return privateKey;
    }

    /**
     * @param privateKey
     *            the privateKey to set
     */
    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    /**
     * @return the transfert
     */
    public TransfertProtocol getTransfert() {
        return transfert;
    }

    /**
     * @param transfert
     *            the transfert to set
     */
    public void setTransfert(TransfertProtocol transfert) {
        this.transfert = transfert;
    }

    /**
     * @return the command
     */
    public CommandProtocol getCommand() {
        return command;
    }

    /**
     * @param command
     *            the command to set
     */
    public void setCommand(CommandProtocol command) {
        this.command = command;
    }

    /**
     * @return the shell
     */
    public Shell getShell() {
        return shell;
    }

    /**
     * @param shell
     *            the shell to set
     */
    public void setShell(Shell shell) {
        this.shell = shell;
    }

    /**
     * @return the agentArchive
     */
    public File getAgentArchive() {
        return agentArchive;
    }

    /**
     * @param agentArchive
     *            the agentArchive to set
     */
    public void setAgentArchive(File agentArchive) {
        this.agentArchive = agentArchive;
    }

    /**
     * @return the targetJonasRoot
     */
    public String getTargetJonasRoot() {
        return targetJonasRoot;
    }

    /**
     * @param targetJonasRoot
     *            the targetJonasRoot to set
     */
    public void setTargetJonasRoot(String targetJonasRoot) {
        this.targetJonasRoot = targetJonasRoot;
    }

    /**
     * @return the targetJonasName
     */
    public String getTargetJonasName() {
        return targetJonasName;
    }

    /**
     * @param targetJonasName
     *            the targetJonasName to set
     */
    public void setTargetJonasName(String targetJonasName) {
        this.targetJonasName = targetJonasName;
    }

    /**
     * @return the targetHTTPPort
     */
    public int getTargetHTTPPort() {
        return targetHTTPPort;
    }

    /**
     * @param targetHTTPPort
     *            the targetHTTPPort to set
     */
    public void setTargetHTTPPort(int targetHTTPPort) {
        this.targetHTTPPort = targetHTTPPort;
    }

    /**
     * @return the targetJonasDomain
     */
    public String getTargetJonasDomain() {
        return targetJonasDomain;
    }

    /**
     * @param targetJonasDomain
     *            the targetJonasDomain to set
     */
    public void setTargetJonasDomain(String targetJonasDomain) {
        this.targetJonasDomain = targetJonasDomain;
    }

}
