/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DirectoryFilter.java 9171 2011-10-13 14:30:56Z richardd $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.agent.utils.filesystem.discovery.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;

/**
 * A singleton FileFilter which will accept only directories
 * 
 * @author Julien Vey
 */
public class DirectoryFilter implements FileFilter {

    /**
     * The instance of this DirectoryFilter
     */
    private static DirectoryFilter instance;

    /**
     * Default private constructor
     */
    private DirectoryFilter() {
    }

    /* (non-Javadoc)
     * @see java.io.FileFilter#accept(java.io.File)
     */
    public boolean accept(File file) {
        try {
            return (file.isDirectory() && file.getAbsolutePath().equals(file.getCanonicalPath()));
        } catch (IOException e) {
            return false;
        }
    }

    /**
     * get the instance of this DirectoryFilter
     * 
     * @return the instance of the DirectoryFilter
     */
    public static synchronized DirectoryFilter getInstance() {
        if (instance == null) {
            instance = new DirectoryFilter();
        }
        return instance;
    }

}
