/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Child.java 9171 2011-10-13 14:30:56Z richardd $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.agent.utils.pattern;

import java.util.LinkedList;
import java.util.List;

/**
 * Defines a child, which is either a directory or a file. A child is used in a DiscoveryPattern
 * 
 * @author Julien Vey
 */
public class Child {

    /**
     * The name of the child
     */
    String name;

    /**
     * The type of the child
     */
    ChildType type;

    /**
     * The list of its children
     */
    List<Child> children;

    /**
     * Default constructor with only a name and a type
     * 
     * @param name
     *            the name of the child
     * @param type
     *            the type of the child
     */
    public Child(String name, ChildType type) {
        this.name = name;
        this.type = type;
        children = new LinkedList<Child>();
    }

    /**
     * Constructor with a name, a type, and a list of children
     * 
     * @param name
     * @param type
     * @param children
     */
    public Child(String name, ChildType type, List<Child> children) {
        this.name = name;
        this.type = type;
        this.children = children;
    }

    /**
     * Add a child to the child list of the current child
     * 
     * @param c
     *            the child to add
     */
    public void addChild(Child c) {
        children.add(c);
    }

    /**
     * @return the type
     */
    public ChildType getType() {
        return type;
    }

    /**
     * @param type
     *            the type to set
     */
    public void setType(ChildType type) {
        this.type = type;
    }

    /**
     * @return the children
     */
    public List<Child> getChildren() {
        return children;
    }

    /**
     * @param children
     *            the children to set
     */
    public void setChildren(List<Child> children) {
        this.children = children;
    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * @param name
     *            the name to set
     */
    public void setName(String name) {
        this.name = name;
    }


}
