/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DiscoveryPattern.java 9171 2011-10-13 14:30:56Z richardd $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.agent.utils.pattern;

import java.util.List;

/**
 * Defines a DiscoveryPattern, which is only a list of child
 * 
 * @author Julien Vey
 */
public class DiscoveryPattern {

    /**
     * the child list
     */
    List<Child> childList;

    /**
     * Default constructor with a list of Child
     * 
     * @param childList the child list of this pattern
     */
    public DiscoveryPattern(List<Child> childList) {
        this.childList = childList;
    }

    /**
     * @return the childList
     */
    public List<Child> getChildList() {
        return childList;
    }

    /**
     * @param childList
     *            the childList to set
     */
    public void setChildList(List<Child> childList) {
        this.childList = childList;
    }
}
