/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.trace;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.objectweb.util.monolog.api.HandlerFactory;
import org.objectweb.util.monolog.api.LevelFactory;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.objectweb.util.monolog.file.monolog.PropertiesConfAccess;
import org.objectweb.util.trace.Trace;
import org.objectweb.util.trace.TraceTemplate;

public class TraceSystem {
    protected static final String prefix = "org.objectweb.util";
    protected static Map list_ = new HashMap();
    protected static String level_ = "default";

    protected static LoggerFactory getLoggerFactory() {
        Properties props = new Properties();
        try {
            props.load(Thread.currentThread().getContextClassLoader().getResourceAsStream(level_ + ".properties"));
        }
        catch (Exception e) {
            System.err.println("Configuration file for log not found. Traces are disabled: " + e);
            return null;
        }
        String lfClassName = props.getProperty("log.config.classname", null);
        if (lfClassName == null) {
            System.err.println("Malformed log configuration file: log.config.classname not available");
        }
        try {
            LoggerFactory lf = (LoggerFactory)Class.forName(lfClassName).newInstance();
            PropertiesConfAccess.load((Properties)props, (LoggerFactory)lf, (HandlerFactory)((HandlerFactory)lf), (LevelFactory)((LevelFactory)lf));
            return lf;
        }
        catch (Exception e) {
            System.err.println("Logs are disabled:" + e);
            return null;
        }
    }

    protected static void create(String logger) {
        list_.put(logger, new TraceTemplate(TraceSystem.getLoggerFactory().getLogger("org.objectweb.util." + logger)));
    }

    public static void setLevel(String level) {
        level_ = level;
    }

    public static Trace get(String id) {
        if (!list_.containsKey(id)) {
            TraceSystem.create(id);
        }
        return (Trace)list_.get(id);
    }
}

