/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.explorer;

import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Fractal;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.AttributeController;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.api.control.NameController;
import org.objectweb.fractal.api.control.SuperController;
import org.objectweb.fractal.api.factory.Factory;
import org.objectweb.fractal.api.factory.GenericFactory;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.api.type.TypeFactory;

public class FcExplorer {
    public static Interface getPrimitiveItf(Interface itf) {
        Component cpt = itf.getFcItfOwner();
        try {
            BindingController bc = FcExplorer.getBindingController(cpt);
            Interface internal = (Interface)bc.lookupFc(itf.getFcItfName());
            return FcExplorer.getPrimitiveItf(internal);
        }
        catch (NoSuchInterfaceException ex) {
            return itf;
        }
    }

    public static Component getPrimitiveCpt(Interface itf) {
        return FcExplorer.getPrimitiveItf(itf).getFcItfOwner();
    }

    public static String getLifeCycleState(Interface itf) {
        try {
            LifeCycleController lc = FcExplorer.getLifeCycleController(FcExplorer.getPrimitiveCpt(itf));
            return lc.getFcState();
        }
        catch (NoSuchInterfaceException ex) {
            return "STARTED";
        }
    }

    public static Component getComponent(Object obj) {
        if (obj instanceof Component) {
            return (Component)obj;
        }
        return ((Interface)obj).getFcItfOwner();
    }

    public static String getPrefixedName(Object obj) {
        if (obj instanceof Component) {
            return FcExplorer.getName((Component)obj);
        }
        return FcExplorer.getName(FcExplorer.getComponent(obj)) + "." + FcExplorer.getName(obj);
    }

    public static String getName(Object obj) {
        if (obj instanceof Component) {
            return FcExplorer.getName((Component)obj);
        }
        if (obj instanceof Interface) {
            return FcExplorer.getName((Interface)obj);
        }
        return "unknown";
    }

    public static String getName(InterfaceType itf) {
        return itf.getFcItfName();
    }

    public static String getName(Interface itf) {
        return itf.getFcItfName();
    }

    public static String getName(Component cpt) {
        try {
            NameController nc = FcExplorer.getNameController(cpt);
            if (nc != null) {
                return nc.getFcName();
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            // empty catch block
        }
        if (cpt instanceof Interface) {
            return FcExplorer.getName((Interface)cpt);
        }
        return "unknown";
    }

    public static Component getBootstrapComponent() throws InstantiationException {
        try {
            return Fractal.getBootstrapComponent();
        }
        catch (NullPointerException ex) {
            throw new InstantiationException("client interface not bound");
        }
    }

    public static AttributeController getAttributeController(Component component) throws NoSuchInterfaceException {
        try {
            return (AttributeController)component.getFcInterface("attribute-controller");
        }
        catch (NullPointerException ex) {
            throw new NoSuchInterfaceException("client interface not bound");
        }
    }

    public static BindingController getBindingController(Component component) throws NoSuchInterfaceException {
        try {
            return (BindingController)component.getFcInterface("binding-controller");
        }
        catch (NullPointerException ex) {
            throw new NoSuchInterfaceException("client interface not bound");
        }
    }

    public static ContentController getContentController(Component component) throws NoSuchInterfaceException {
        try {
            return (ContentController)component.getFcInterface("content-controller");
        }
        catch (NullPointerException ex) {
            throw new NoSuchInterfaceException("client interface not bound");
        }
    }

    public static SuperController getSuperController(Component component) throws NoSuchInterfaceException {
        try {
            return (SuperController)component.getFcInterface("super-controller");
        }
        catch (NullPointerException ex) {
            throw new NoSuchInterfaceException("client interface not bound");
        }
    }

    public static NameController getNameController(Component component) throws NoSuchInterfaceException {
        try {
            return (NameController)component.getFcInterface("name-controller");
        }
        catch (NullPointerException ex) {
            throw new NoSuchInterfaceException("client interface not bound");
        }
    }

    public static LifeCycleController getLifeCycleController(Component component) throws NoSuchInterfaceException {
        try {
            return (LifeCycleController)component.getFcInterface("lifecycle-controller");
        }
        catch (NullPointerException ex) {
            throw new NoSuchInterfaceException("client interface not bound");
        }
    }

    public static Factory getFactory(Component component) throws NoSuchInterfaceException {
        try {
            return (Factory)component.getFcInterface("factory");
        }
        catch (NullPointerException ex) {
            throw new NoSuchInterfaceException("client interface not bound");
        }
    }

    public static GenericFactory getGenericFactory(Component component) throws NoSuchInterfaceException {
        try {
            return (GenericFactory)component.getFcInterface("generic-factory");
        }
        catch (NullPointerException ex) {
            throw new NoSuchInterfaceException("client interface not bound");
        }
    }

    public static TypeFactory getTypeFactory(Component component) throws NoSuchInterfaceException {
        try {
            return (TypeFactory)component.getFcInterface("type-factory");
        }
        catch (NullPointerException ex) {
            throw new NoSuchInterfaceException("client interface not bound");
        }
    }

    public static boolean isClient(Interface ir) {
        InterfaceType it = (InterfaceType)ir.getFcItfType();
        return it.isFcClientItf();
    }

    public static boolean isCollection(Interface itf) {
        InterfaceType iType = (InterfaceType)itf.getFcItfType();
        return iType.isFcCollectionItf();
    }

    public static boolean isClientCollection(InterfaceType it) {
        return it.isFcClientItf() && it.isFcCollectionItf();
    }

    public static boolean isClientCollection(Interface ir) {
        return FcExplorer.isClientCollection((InterfaceType)ir.getFcItfType());
    }

    public static boolean isController(Interface itf) {
        String itfName = itf.getFcItfName();
        return itfName.endsWith("-controller") || itfName.equals("factory") || itfName.equals("component");
    }

    public static ImageIcon createIcon(String imageName) {
        if (imageName != null) {
            URL urlFile = null;
            urlFile = Thread.currentThread().getContextClassLoader().getResource(imageName);
            if (urlFile == null) {
                try {
                    urlFile = new URL(imageName);
                }
                catch (MalformedURLException e) {
                    System.out.println(imageName + ": Malformed URL !");
                }
            }
            if (urlFile != null) {
                return new ImageIcon(urlFile);
            }
        }
        return null;
    }
}

