/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.explorer.attributes;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;

public class AttributeValueDefaultCellEditor
extends DefaultCellEditor {
    JTextField attributeEditorDefaultValue = null;
    Object cellEditorValue = null;
    private boolean initialized = false;
    private AttributeValueTextFieldActionListener actionListener = null;
    int row;
    Object oldValue;
    boolean actionPerformed = false;

    public AttributeValueDefaultCellEditor(JTextField textField) {
        super(textField);
        this.attributeEditorDefaultValue = textField;
        this.attributeEditorDefaultValue.setHorizontalAlignment(4);
        super.setClickCountToStart(1);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row1, int column) {
        this.actionPerformed = false;
        if (!this.initialized) {
            this.attributeEditorDefaultValue.setFont(table.getFont());
            this.actionListener = new AttributeValueTextFieldActionListener(table);
            this.attributeEditorDefaultValue.addActionListener(this.actionListener);
            this.initialized = true;
        }
        this.row = row1;
        this.oldValue = value;
        if (value != null) {
            this.attributeEditorDefaultValue.setText(value.toString());
        }
        return this.attributeEditorDefaultValue;
    }

    public Object getCellEditorValue() {
        if (this.actionPerformed) {
            return this.cellEditorValue;
        }
        return this.oldValue;
    }

    private class AttributeValueTextFieldActionListener
    implements ActionListener {
        private JTable table = null;

        public AttributeValueTextFieldActionListener(JTable table) {
            this.table = table;
        }

        public void actionPerformed(ActionEvent evt) {
            AttributeValueDefaultCellEditor.this.actionPerformed = true;
            String attributeName = this.table.getValueAt(AttributeValueDefaultCellEditor.this.row, 0).toString();
            String newValueString = AttributeValueDefaultCellEditor.this.attributeEditorDefaultValue.getText().toLowerCase().trim();
            Object newValue = null;
            boolean doUpdate = false;
            if (AttributeValueDefaultCellEditor.this.oldValue instanceof String) {
                newValue = AttributeValueDefaultCellEditor.this.attributeEditorDefaultValue.getText();
                doUpdate = true;
            } else if (AttributeValueDefaultCellEditor.this.oldValue instanceof Integer) {
                doUpdate = true;
                try {
                    newValue = Integer.valueOf(newValueString);
                }
                catch (Exception e) {
                    doUpdate = false;
                    this.showAttributeValueErrorMessage(attributeName, "Integer");
                }
            } else if (AttributeValueDefaultCellEditor.this.oldValue instanceof Short) {
                doUpdate = true;
                try {
                    newValue = Short.valueOf(newValueString);
                }
                catch (Exception e) {
                    doUpdate = false;
                    this.showAttributeValueErrorMessage(attributeName, "Short");
                }
            } else if (AttributeValueDefaultCellEditor.this.oldValue instanceof Long) {
                doUpdate = true;
                try {
                    newValue = Long.valueOf(newValueString);
                }
                catch (Exception e) {
                    doUpdate = false;
                    this.showAttributeValueErrorMessage(attributeName, "Long");
                }
            } else if (AttributeValueDefaultCellEditor.this.oldValue instanceof Double) {
                doUpdate = true;
                try {
                    newValue = Double.valueOf(newValueString);
                }
                catch (Exception e) {
                    doUpdate = false;
                    this.showAttributeValueErrorMessage(attributeName, "Double");
                }
            } else if (AttributeValueDefaultCellEditor.this.oldValue instanceof Float) {
                doUpdate = true;
                try {
                    newValue = Float.valueOf(newValueString);
                }
                catch (Exception e) {
                    doUpdate = false;
                    this.showAttributeValueErrorMessage(attributeName, "Float");
                }
            }
            if (doUpdate && newValue != null) {
                AttributeValueDefaultCellEditor.this.cellEditorValue = newValue;
                AttributeValueDefaultCellEditor.this.fireEditingStopped();
            } else {
                AttributeValueDefaultCellEditor.this.fireEditingCanceled();
            }
        }

        private void showAttributeValueErrorMessage(String attributeName, String requiredType) {
            JOptionPane.showMessageDialog(this.table, "Value of attribute '" + attributeName + "' must be of type " + requiredType.toUpperCase(), "Wrong attribute value", 0);
        }
    }
}

