/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.explorer.attributes;

import javax.swing.table.AbstractTableModel;
import org.objectweb.fractal.explorer.attributes.AttributeDescriptor;

public class AttributesTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"AttributeName", "AttributeValue", "Monitor"};
    private AttributeDescriptor[] attributes = null;
    public static final String[] MONITOR_ACTIONS = new String[]{"start", "stop"};

    public AttributesTableModel(AttributeDescriptor[] attributes) {
        this.attributes = attributes;
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public int getRowCount() {
        return this.attributes.length;
    }

    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public synchronized Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return this.attributes[row].getName();
            }
            case 1: {
                return this.attributes[row].getValue();
            }
            case 2: {
                return this.attributes[row].hasMonitor() ? MONITOR_ACTIONS[1] : MONITOR_ACTIONS[0];
            }
        }
        return null;
    }

    public synchronized Class getColumnClass(int column) {
        if (column != 1) {
            return this.getValueAt(0, column).getClass();
        }
        return Object.class;
    }

    public boolean isCellEditable(int row, int column) {
        if (column == 0) {
            return false;
        }
        if (column == 1) {
            return this.attributes[row].isMutable() && !this.attributes[row].hasMonitor();
        }
        return true;
    }

    public synchronized void setValueAt(Object value, int row, int column) {
        if (column == 1) {
            if (this.attributes[row] != null) {
                this.attributes[row].setValue(value);
            } else {
                String attributeName = this.getValueAt(row, 0).toString();
                this.attributes[row] = new AttributeDescriptor(attributeName, value, true);
            }
            this.fireTableCellUpdated(row, column);
        } else if (column == 2) {
            this.fireTableCellUpdated(row, column);
        }
    }

    public AttributeDescriptor[] getAttributeDescriptors() {
        return this.attributes;
    }

    public AttributeDescriptor getAttributeDescriptor(int row) {
        return this.attributes[row];
    }
}

