/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.explorer.context;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.explorer.FcExplorer;
import org.objectweb.fractal.explorer.context.ClientCollectionInterfaceContainer;
import org.objectweb.fractal.explorer.context.ClientInterfaceWrapper;
import org.objectweb.fractal.explorer.context.ControllerContainer;
import org.objectweb.fractal.explorer.context.ServerCollectionInterfaceContainer;
import org.objectweb.util.explorer.api.Context;
import org.objectweb.util.explorer.api.Entry;
import org.objectweb.util.explorer.core.common.api.ContextContainer;
import org.objectweb.util.explorer.core.common.lib.DefaultContextContainer;
import org.objectweb.util.explorer.core.naming.lib.DefaultEntry;

public class ComponentContextForService
implements Context {
    protected ContextContainer controllers = null;

    public Entry[] getEntries(Object object) {
        Component component = (Component)object;
        Hashtable<String, DefaultContextContainer> collections = new Hashtable<String, DefaultContextContainer>();
        ArrayList<DefaultEntry> entries = new ArrayList<DefaultEntry>();
        ComponentType cType = (ComponentType)component.getFcType();
        InterfaceType[] iTypes = cType.getFcInterfaceTypes();
        for (int i = 0; i < iTypes.length; ++i) {
            if (!iTypes[i].isFcCollectionItf()) continue;
            DefaultContextContainer cc = iTypes[i].isFcClientItf() ? new ClientCollectionInterfaceContainer(iTypes[i], component) : new ServerCollectionInterfaceContainer(iTypes[i], component);
            collections.put(iTypes[i].getFcItfName(), cc);
        }
        this.controllers = new ControllerContainer();
        Object[] interfaces = component.getFcInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (component.equals(interfaces[i])) continue;
            Interface itf = (Interface)interfaces[i];
            if (FcExplorer.isController(itf)) {
                this.controllers.addEntry((Object)FcExplorer.getName(itf), (Object)itf);
                continue;
            }
            if (FcExplorer.isCollection(itf)) {
                InterfaceType iType = (InterfaceType)itf.getFcItfType();
                String name = FcExplorer.getName(itf);
                Object context = FcExplorer.isClient(itf) ? new ClientInterfaceWrapper(itf) : itf;
                ((ContextContainer)collections.get(iType.getFcItfName())).addEntry((Object)name, context);
                continue;
            }
            if (FcExplorer.isClient(itf)) {
                entries.add(new DefaultEntry((Object)FcExplorer.getName(itf), (Object)new ClientInterfaceWrapper(itf)));
                continue;
            }
            entries.add(new DefaultEntry((Object)FcExplorer.getName(itf), (Object)itf));
        }
        Enumeration keys = collections.keys();
        Enumeration elements = collections.elements();
        for (int i = 0; i < collections.size(); ++i) {
            entries.add(new DefaultEntry(keys.nextElement(), elements.nextElement()));
        }
        return entries.toArray(new Entry[0]);
    }
}

