/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.explorer.graph;

import java.awt.Dimension;
import java.util.List;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphModel;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.explorer.FcExplorer;
import org.objectweb.fractal.explorer.graph.GraphInformations;
import org.objectweb.fractal.explorer.graph.PortGraphics;
import org.objectweb.fractal.explorer.graph.VertexGraphics;
import org.objectweb.util.explorer.swing.graph.CompositeVertex;
import org.objectweb.util.explorer.swing.graph.Graph;
import org.objectweb.util.explorer.swing.graph.MyPort;
import org.objectweb.util.explorer.swing.graph.PortGraphicsInterface;
import org.objectweb.util.explorer.swing.graph.PrimitiveVertex;
import org.objectweb.util.explorer.swing.graph.VertexGraphicsInterface;

public class FractalGraph {
    protected void addPortsComposite(Component component, CompositeVertex composite) {
        Interface[] listExtItf = GraphInformations.getSortExtItf(component);
        for (int i = 0; i < listExtItf.length; ++i) {
            String nameItf = GraphInformations.getInterfaceName(listExtItf[i]);
            String typePort = GraphInformations.getPortType(listExtItf[i]);
            if (typePort.equals("collection")) continue;
            composite.addCompositePort((Object)listExtItf[i], nameItf, typePort);
        }
        List listItfCollection = GraphInformations.getItfCollection(component);
        if (listItfCollection.size() != 0) {
            for (int j = 0; j < listItfCollection.size(); ++j) {
                InterfaceType itType = (InterfaceType)listItfCollection.get(j);
                composite.addCompositePort(listItfCollection.get(j), itType.getFcItfName(), "collection");
            }
        }
    }

    protected void addPortsPrimitive(Component component, PrimitiveVertex primitive) {
        Interface[] listExtItf = GraphInformations.getSortExtItf(component);
        for (int i = 0; i < listExtItf.length; ++i) {
            String nameItf = GraphInformations.getInterfaceName(listExtItf[i]);
            String typePort = GraphInformations.getPortType(listExtItf[i]);
            if (typePort.equals("collection")) continue;
            primitive.addPort((Object)listExtItf[i], nameItf, typePort);
        }
        List listItfCollection = GraphInformations.getItfCollection(component);
        if (listItfCollection.size() != 0) {
            for (int j = 0; j < listItfCollection.size(); ++j) {
                InterfaceType itType = (InterfaceType)listItfCollection.get(j);
                primitive.addPort(listItfCollection.get(j), itType.getFcItfName(), "collection");
            }
        }
    }

    protected void addNeighbors(Component component, PrimitiveVertex primitiveVertex, Graph graph, boolean controllersDisplay) {
        String namePort;
        InterfaceType itType;
        Interface targetItf;
        Component targetComponent;
        int j;
        Interface[] listExtItf;
        Object neighborVertex;
        Component neighborComponent;
        int i;
        List serverNeighbors = GraphInformations.getServerNeighbors(component);
        List clientNeighbors = GraphInformations.getClientNeighbors(component);
        boolean isOpen = false;
        boolean isCompositeEdge = false;
        for (i = 0; i < serverNeighbors.size(); ++i) {
            neighborComponent = (Component)serverNeighbors.get(i);
            neighborVertex = GraphInformations.isPrimitiveComponent(neighborComponent) ? new PrimitiveVertex((Object)neighborComponent, FcExplorer.getName(neighborComponent), graph, new Dimension(), controllersDisplay, GraphInformations.isStarted(neighborComponent), GraphInformations.isSharedComponent(neighborComponent)) : new CompositeVertex((Object)neighborComponent, FcExplorer.getName(neighborComponent), graph, new Dimension(), isOpen, controllersDisplay, GraphInformations.isStarted(neighborComponent), GraphInformations.isSharedComponent(neighborComponent));
            graph.addPrimitiveComponent(neighborVertex);
            this.addPortsPrimitive(neighborComponent, (PrimitiveVertex)neighborVertex);
            listExtItf = GraphInformations.getSortExtItf(neighborComponent);
            for (j = 0; j < listExtItf.length; ++j) {
                if (!GraphInformations.isClientInterface(listExtItf[j]) || !(targetComponent = GraphInformations.getTargetComponent(neighborComponent, listExtItf[j])).equals(component)) continue;
                targetItf = GraphInformations.getTargetInterface(neighborComponent, listExtItf[j]);
                if (GraphInformations.isCollectionInterface(listExtItf[j])) {
                    itType = (InterfaceType)listExtItf[j].getFcItfType();
                    namePort = itType.getFcItfName();
                } else {
                    namePort = GraphInformations.getInterfaceName(listExtItf[j]);
                }
                graph.primitiveConnect(neighborVertex.getPort(namePort), primitiveVertex.getPort(GraphInformations.getInterfaceName(targetItf)), isCompositeEdge);
            }
        }
        for (i = 0; i < clientNeighbors.size(); ++i) {
            neighborComponent = (Component)clientNeighbors.get(i);
            neighborVertex = GraphInformations.isPrimitiveComponent(neighborComponent) ? new PrimitiveVertex((Object)neighborComponent, FcExplorer.getName(neighborComponent), graph, new Dimension(), controllersDisplay, GraphInformations.isStarted(neighborComponent), GraphInformations.isSharedComponent(neighborComponent)) : new CompositeVertex((Object)neighborComponent, FcExplorer.getName(neighborComponent), graph, new Dimension(), isOpen, controllersDisplay, GraphInformations.isStarted(neighborComponent), GraphInformations.isSharedComponent(neighborComponent));
            graph.addPrimitiveComponent(neighborVertex);
            this.addPortsPrimitive(neighborComponent, (PrimitiveVertex)neighborVertex);
            listExtItf = GraphInformations.getSortExtItf(component);
            for (j = 0; j < listExtItf.length; ++j) {
                if (!GraphInformations.isClientInterface(listExtItf[j]) || !(targetComponent = GraphInformations.getTargetComponent(component, listExtItf[j])).equals(neighborComponent)) continue;
                targetItf = GraphInformations.getTargetInterface(component, listExtItf[j]);
                if (GraphInformations.isCollectionInterface(listExtItf[j])) {
                    itType = (InterfaceType)listExtItf[j].getFcItfType();
                    namePort = itType.getFcItfName();
                } else {
                    namePort = GraphInformations.getInterfaceName(listExtItf[j]);
                }
                graph.primitiveConnect(primitiveVertex.getPort(namePort), neighborVertex.getPort(GraphInformations.getInterfaceName(targetItf)), isCompositeEdge);
            }
        }
    }

    protected void addSubComponentPorts(CompositeVertex composite, Component subComponent) {
        Interface[] listExtItf = GraphInformations.getSortExtItf(subComponent);
        for (int i = 0; i < listExtItf.length; ++i) {
            String portName = GraphInformations.getInterfaceName(listExtItf[i]);
            String typePort = GraphInformations.getPortType(listExtItf[i]);
            if (typePort.equals("collection")) continue;
            composite.addSubComponentPort(FcExplorer.getName(subComponent), (Object)subComponent, portName, typePort);
        }
        List listItfCollection = GraphInformations.getItfCollection(subComponent);
        if (listItfCollection.size() != 0) {
            for (int j = 0; j < listItfCollection.size(); ++j) {
                InterfaceType itType = (InterfaceType)listItfCollection.get(j);
                composite.addSubComponentPort(FcExplorer.getName(subComponent), (Object)subComponent, itType.getFcItfName(), "collection");
            }
        }
    }

    protected void addSubComponents(Graph graph, Component superComponent, CompositeVertex composite) {
        Component[] listSubComponents = GraphInformations.getSubComponents(superComponent);
        String nameSubComponent = "";
        for (int i = 0; i < listSubComponents.length; ++i) {
            Component subComponent = listSubComponents[i];
            composite.addVertex((Object)subComponent, FcExplorer.getName(subComponent), graph, GraphInformations.getComponentType(subComponent), false, true, GraphInformations.isStarted(subComponent), GraphInformations.isSharedComponent(subComponent));
            this.addSubComponentPorts(composite, subComponent);
        }
    }

    protected void drawBind(Graph graph, Object component, String namePort, Object targetComponent, String nameTargetPort, CompositeVertex composite, boolean isInternalEdge) {
        MyPort sourcePort = !isInternalEdge ? composite.getVertex(component).getPort(namePort) : composite.getGeneratedPort(namePort);
        MyPort targetPort = composite.getVertex(targetComponent).getPort(nameTargetPort);
        graph.compositeConnect(sourcePort, targetPort, isInternalEdge, composite);
    }

    protected void addBinds(Graph graph, Component superComponent, CompositeVertex composite) {
        Component[] listSubComponents = GraphInformations.getSubComponents(superComponent);
        for (int i = 0; i < listSubComponents.length; ++i) {
            Component subComponent = listSubComponents[i];
            Interface[] listExtItf = GraphInformations.getSortExtItf(subComponent);
            for (int j = 0; j < listExtItf.length; ++j) {
                String namePort;
                Interface itf = listExtItf[j];
                if (!GraphInformations.isClientInterface(itf) || GraphInformations.getTargetComponent(subComponent, itf) == null || GraphInformations.getTargetInterface(subComponent, itf) == null) continue;
                if (GraphInformations.isCollectionInterface(itf)) {
                    InterfaceType itType = (InterfaceType)itf.getFcItfType();
                    namePort = itType.getFcItfName();
                } else {
                    namePort = GraphInformations.getInterfaceName(itf);
                }
                Component targetComponent = GraphInformations.getTargetComponent(subComponent, itf);
                String nameTargetPort = GraphInformations.getInterfaceName(GraphInformations.getTargetInterface(subComponent, itf));
                if (GraphInformations.getTargetInterface(subComponent, itf).isFcInternalItf() && superComponent.equals(targetComponent)) {
                    this.drawBind(graph, superComponent, nameTargetPort, subComponent, namePort, composite, true);
                    continue;
                }
                if (GraphInformations.getTargetInterface(subComponent, itf).isFcInternalItf()) continue;
                this.drawBind(graph, subComponent, namePort, targetComponent, nameTargetPort, composite, false);
            }
        }
    }

    protected void addInternalBinds(Graph graph, Component superComponent, CompositeVertex composite) {
        Interface[] listIntItf = GraphInformations.getIntItf(superComponent);
        for (int i = 0; i < listIntItf.length; ++i) {
            Interface internalItf = listIntItf[i];
            if (GraphInformations.getPortType(internalItf) == "server" || GraphInformations.getTargetComponent(superComponent, internalItf) == null || GraphInformations.getTargetInterface(superComponent, internalItf) == null) continue;
            String nameInternalItf = GraphInformations.getInterfaceName(internalItf);
            String nameTargetPort = GraphInformations.getInterfaceName(GraphInformations.getTargetInterface(superComponent, internalItf));
            Component targetComponent = GraphInformations.getTargetComponent(superComponent, internalItf);
            this.drawBind(graph, superComponent, nameInternalItf, targetComponent, nameTargetPort, composite, true);
        }
    }

    public Graph getFractalGraph(Component component) {
        String nameComponent = FcExplorer.getName(component);
        PortGraphics pg = new PortGraphics();
        VertexGraphics vg = new VertexGraphics();
        Dimension frameSize = new Dimension(100, 100);
        DefaultGraphModel model = new DefaultGraphModel();
        Graph graph = new Graph((GraphModel)model, (PortGraphicsInterface)pg, (VertexGraphicsInterface)vg);
        graph.setPortsVisible(true);
        boolean controllersDisplay = true;
        boolean isPrimitive = GraphInformations.isPrimitiveComponent(component);
        if (!isPrimitive) {
            boolean isOpen = true;
            CompositeVertex compositeVertex = new CompositeVertex((Object)component, nameComponent, graph, frameSize, isOpen, controllersDisplay, GraphInformations.isStarted(component), GraphInformations.isSharedComponent(component));
            graph.addSuperComponent(compositeVertex);
            this.addPortsComposite(component, compositeVertex);
            this.addSubComponents(graph, component, compositeVertex);
            this.addBinds(graph, component, compositeVertex);
            this.addInternalBinds(graph, component, compositeVertex);
            graph.insertIntoModel(isPrimitive);
            graph.applyLayout(compositeVertex);
            return graph;
        }
        PrimitiveVertex primitiveVertex = new PrimitiveVertex((Object)component, nameComponent, graph, new Dimension(), controllersDisplay, GraphInformations.isStarted(component), GraphInformations.isSharedComponent(component));
        graph.addPrimitiveComponent(primitiveVertex);
        this.addPortsPrimitive(component, primitiveVertex);
        this.addNeighbors(component, primitiveVertex, graph, controllersDisplay);
        graph.insertIntoModel(isPrimitive);
        graph.applyLayout(frameSize);
        return graph;
    }
}

