/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.explorer.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import org.objectweb.util.explorer.swing.graph.CompositeVertex;
import org.objectweb.util.explorer.swing.graph.PrimitiveVertex;
import org.objectweb.util.explorer.swing.graph.VertexGraphicsInterface;

public class VertexGraphics
implements VertexGraphicsInterface {
    private void drawDottedRect(Graphics g, int x, int y, int width, int height) {
        int currentY = y;
        for (int currentX = x; currentX < x + width - 5; currentX += 10) {
            g.drawLine(currentX, y, currentX + 5, y);
            g.drawLine(currentX, y + height, currentX + 5, y + height);
        }
        while (currentY < y + height - 5) {
            g.drawLine(x, currentY, x, currentY + 5);
            g.drawLine(x + width, currentY, x + width, currentY + 5);
            currentY += 10;
        }
    }

    public Font getTextFont() {
        return new Font("SansSerif", 1, 10);
    }

    public Dimension getDefaultSize() {
        return new Dimension(110, 60);
    }

    public Dimension getSuperCompositeSize() {
        return new Dimension(10, 10);
    }

    public void drawVertex(Graphics g, String vertexType, Dimension d, PrimitiveVertex vertex) {
        g.setColor(Color.DARK_GRAY);
        if (!vertex.isStarted()) {
            g.setColor(new Color(149, 0, 0));
        }
        if (vertexType.equals("primitif")) {
            int size = 1;
            if (vertex.isShared()) {
                this.drawDottedRect(g, 0, 0, d.width - 1, d.height - 1);
                this.drawDottedRect(g, size, size, d.width - 3, d.height - 3);
            } else {
                g.drawRect(0, 0, d.width - 1, d.height - 1);
                g.drawRect(size, size, d.width - 3, d.height - 3);
            }
        } else if (vertexType.equals("composite")) {
            if (!((CompositeVertex)vertex).isOpen()) {
                int size = 1;
                if (vertex.isShared()) {
                    this.drawDottedRect(g, 0, 0, d.width - 1, d.height - 1);
                    this.drawDottedRect(g, size, size, d.width - size - 2, d.height - size - 2);
                } else {
                    g.drawRect(0, 0, d.width - 1, d.height - 1);
                    g.drawRect(size, size, d.width - size - 2, d.height - size - 2);
                }
                g.setColor(Color.PINK);
                g.fillRect(size + 1, size + 1, d.width - (size + 1) - 2, d.height - (size + 1) - 2);
            } else {
                int size = 5;
                if (vertex.isShared()) {
                    this.drawDottedRect(g, 0, 0, d.width - 1, d.height - 1);
                    this.drawDottedRect(g, 1, 1, d.width - 3, d.height - 3);
                    this.drawDottedRect(g, size, size, d.width - size * 2 - 1, d.height - size * 2 - 1);
                    this.drawDottedRect(g, size + 1, size + 1, d.width - size * 2 - 3, d.height - size * 2 - 3);
                } else {
                    g.drawRect(0, 0, d.width - 1, d.height - 1);
                    g.drawRect(1, 1, d.width - 3, d.height - 3);
                    g.drawRect(size, size, d.width - size * 2 - 1, d.height - size * 2 - 1);
                    g.drawRect(size + 1, size + 1, d.width - size * 2 - 3, d.height - size * 2 - 3);
                }
            }
        }
    }
}

