/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.explorer.menu;

import java.awt.Dimension;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.explorer.FcExplorer;
import org.objectweb.fractal.explorer.context.ClientInterfaceWrapper;
import org.objectweb.util.explorer.api.MenuItem;
import org.objectweb.util.explorer.api.MenuItemTreeView;
import org.objectweb.util.explorer.api.TreeView;
import org.objectweb.util.explorer.swing.gui.api.DialogAction;
import org.objectweb.util.explorer.swing.gui.api.ElementBox;
import org.objectweb.util.explorer.swing.gui.lib.DefaultDialogBox;
import org.objectweb.util.explorer.swing.gui.lib.TreeBox;

public class BindAction
implements MenuItem,
DialogAction {
    protected TreeBox treeBox_;
    protected Interface clientInterface_;

    public int getStatus(TreeView treeView) {
        try {
            boolean started = false;
            ClientInterfaceWrapper cirw = (ClientInterfaceWrapper)treeView.getSelectedObject();
            Interface ir = cirw.getItf();
            Component component = ir.getFcItfOwner();
            LifeCycleController lcc = FcExplorer.getLifeCycleController(component);
            String status = lcc.getFcState();
            if (status.equals("STARTED")) {
                started = true;
            }
            Interface bindInterface = null;
            try {
                BindingController bc = FcExplorer.getBindingController(component);
                bindInterface = (Interface)bc.lookupFc(ir.getFcItfName());
            }
            catch (Exception e) {
                return 3;
            }
            if (bindInterface == null && !started) {
                return 1;
            }
            if (bindInterface == null && started) {
                return 2;
            }
            if (bindInterface != null) {
                return 3;
            }
        }
        catch (NoSuchInterfaceException e) {
            e.printStackTrace();
        }
        return 2;
    }

    public void actionPerformed(MenuItemTreeView e) throws Exception {
        ClientInterfaceWrapper clientWrapper = (ClientInterfaceWrapper)e.getSelectedObject();
        this.clientInterface_ = clientWrapper.getItf();
        this.treeBox_ = new TreeBox(e.getTree().duplicate());
        this.treeBox_.setPreferredSize(new Dimension(450, 350));
        DefaultDialogBox dialog = new DefaultDialogBox("Select the interface to bind");
        dialog.setValidateAction((DialogAction)this);
        dialog.addElementBox((ElementBox)this.treeBox_);
        dialog.show();
    }

    public void executeAction() throws Exception {
        Object o = this.treeBox_.getObject();
        Interface serverInterface = (Interface)o;
        FcExplorer.getBindingController(this.clientInterface_.getFcItfOwner()).bindFc(this.clientInterface_.getFcItfName(), (Object)serverInterface);
    }
}

