/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.explorer.panel;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.NameController;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.explorer.FcExplorer;
import org.objectweb.fractal.explorer.context.InterfaceWrapperFactory;
import org.objectweb.fractal.explorer.lib.SignatureWrapper;
import org.objectweb.util.explorer.api.Entry;
import org.objectweb.util.explorer.api.Table;
import org.objectweb.util.explorer.api.TreeView;
import org.objectweb.util.explorer.core.naming.lib.DefaultEntry;

public class InternalInterfacesTable
implements Table {
    protected NameController nameController_;

    protected Entry getBoundInterface(Interface itf, BindingController bc) {
        if (bc != null) {
            try {
                Interface bindInterface = (Interface)bc.lookupFc(itf.getFcItfName());
                if (bindInterface != null) {
                    return new DefaultEntry((Object)FcExplorer.getPrefixedName(bindInterface), (Object)bindInterface);
                }
            }
            catch (NoSuchInterfaceException e) {
                return null;
            }
        }
        return null;
    }

    protected BindingController getBindingController(Interface itf) {
        Component comp = itf.getFcItfOwner();
        try {
            return FcExplorer.getBindingController(comp);
        }
        catch (NoSuchInterfaceException e) {
            return null;
        }
    }

    protected NameController getNameController(Interface itf) {
        Component comp = itf.getFcItfOwner();
        try {
            return FcExplorer.getNameController(comp);
        }
        catch (NoSuchInterfaceException e) {
            return null;
        }
    }

    protected Object[] getValues(Interface itf, BindingController bc) {
        Object[] values = new Object[3];
        String sign = ((InterfaceType)itf.getFcItfType()).getFcItfSignature();
        values[0] = new DefaultEntry((Object)FcExplorer.getName(itf), (Object)InterfaceWrapperFactory.singleton().getWrapper(itf));
        values[1] = new DefaultEntry((Object)sign, (Object)new SignatureWrapper(sign));
        values[2] = this.getBoundInterface(itf, bc);
        return values;
    }

    protected ContentController provideContentController(TreeView treeView) {
        return (ContentController)treeView.getSelectedObject();
    }

    public String[] getHeaders(TreeView treeView) {
        return new String[]{"Interface", "Type", "Connected"};
    }

    public Object[][] getRows(TreeView treeView) {
        ContentController cc = this.provideContentController(treeView);
        BindingController bc = this.getBindingController((Interface)cc);
        this.nameController_ = this.getNameController((Interface)cc);
        Object[] interfaces = cc.getFcInternalInterfaces();
        Object[][] values = new Object[interfaces.length][1];
        for (int i = 0; i < interfaces.length; ++i) {
            values[i] = this.getValues((Interface)interfaces[i], bc);
        }
        return values;
    }
}

