/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fdf;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class Launcher {
    public static void main(String[] args) throws Throwable {
        ArrayList<String> fcList = new ArrayList<String>();
        String libDir = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-lib")) {
                libDir = i + 1 < args.length ? args[i + 1] : null;
                ++i;
                continue;
            }
            fcList.add(args[i]);
        }
        String mainJavaClassName = (String)fcList.remove(0);
        Class<?> mainJavaClass = null;
        if (libDir != null) {
            File[] libs = new File(libDir).listFiles();
            if (libs == null) {
                System.err.println("Can't list files of '" + libDir + "'");
                System.err.println("Please check arguments.");
                System.exit(1);
            }
            URL[] urls = new URL[libs.length];
            for (int j = 0; j < libs.length; ++j) {
                urls[j] = libs[j].toURL();
            }
            URLClassLoader libClassLoader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(libClassLoader);
            mainJavaClass = Class.forName(mainJavaClassName, true, libClassLoader);
        } else {
            mainJavaClass = Class.forName(mainJavaClassName);
        }
        mainJavaClass.getMethod("main", String[].class).invoke(null, new Object[]{fcList.toArray(new String[fcList.size()])});
    }

    private static void parseError() {
        System.out.println("Usage: " + Launcher.class.getName() + " <javaMainClass> -lib <libDir> <params>");
        System.out.println("where <javaMainClass> is the name of the Java class to run.");
        System.out.println("      <libDir> is the directory containing jars to load.");
        System.out.println("      <params> are the arguments to give to 'javaMainClass'.");
        System.exit(1);
    }
}

