/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.cmdline.lib;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.Vector;
import org.objectweb.util.cmdline.api.CommandLine;
import org.objectweb.util.cmdline.api.Console;
import org.objectweb.util.cmdline.api.Option;
import org.objectweb.util.cmdline.lib.DefaultIterator;
import org.objectweb.util.cmdline.lib.DefaultOptionHelp;
import org.objectweb.util.cmdline.lib.DefaultUsage;
import org.objectweb.util.cmdline.lib.OptionHelper;

public class DefaultCommandLine
extends DefaultUsage
implements CommandLine {
    private Console console_;
    private Vector options_ = new Vector();
    private int maxOptionLength_ = 0;
    private boolean checkingArguments_;

    public DefaultCommandLine() {
        this("", "", (String[])null, false);
    }

    public DefaultCommandLine(boolean with_help) {
        this("", "", (String[])null, with_help);
    }

    public DefaultCommandLine(String label, String arguments, String description, boolean with_help) {
        this(label, arguments, new String[]{description}, with_help);
    }

    public DefaultCommandLine(String[] labels, String arguments, String description, boolean with_help) {
        this(labels, arguments, new String[]{description}, with_help);
    }

    public DefaultCommandLine(String label, String arguments, String[] description, boolean with_help) {
        this(new String[]{label}, arguments, description, with_help);
    }

    public DefaultCommandLine(String[] labels, String arguments, String[] description, boolean with_help) {
        this(labels, new String[]{arguments}, description, with_help);
    }

    public DefaultCommandLine(String[] labels, String[] arguments, String[] description, boolean with_help) {
        this(labels, arguments, false, description, with_help);
    }

    public DefaultCommandLine(String[] labels, String[] arguments, boolean additional, String[] description, boolean with_help) {
        super(labels, arguments, additional, description);
        if (with_help) {
            this.addOption(new DefaultOptionHelp());
        }
        this.console_ = null;
        this.checkingArguments_ = true;
    }

    protected void exit(String message) {
        this.console_.getErrorStream().println(this.getLabels()[0] + ": " + message + '!');
        this.print(this.console_.getErrorStream());
        System.exit(-1);
    }

    protected static int sumStringLength(String[] strings) {
        int result = 0;
        int i = 0;
        while (i < strings.length) {
            result += strings[i].length();
            ++i;
        }
        return result;
    }

    protected static void print(PrintStream stream, String[] strings, String sep_first, String sep_next) {
        if (strings.length > 0) {
            stream.print(sep_first);
            stream.print(strings[0]);
            int i = 1;
            while (i < strings.length) {
                stream.print(sep_next);
                stream.print(strings[i]);
                ++i;
            }
        }
    }

    public void print(PrintStream stream) {
        stream.print("Usage: ");
        stream.print(this.getLabels()[0]);
        Iterator iterator = this.options_.iterator();
        while (iterator.hasNext()) {
            stream.print(' ');
            Option option = (Option)iterator.next();
            if (!option.isMandatory()) {
                stream.print('[');
            }
            DefaultCommandLine.print(stream, option.getLabels(), "", "|");
            DefaultCommandLine.print(stream, option.getArguments(), " ", " ");
            if (option.isMandatory()) continue;
            stream.print(']');
        }
        DefaultCommandLine.print(stream, this.getArguments(), " ", " ");
        stream.println("\n\nOptions:");
        Iterator iterator2 = this.options_.iterator();
        while (iterator2.hasNext()) {
            int nb_characters = 0;
            Option option = (Option)iterator2.next();
            String[] labels = option.getLabels();
            DefaultCommandLine.print(stream, labels, "  ", ", ");
            nb_characters = nb_characters + DefaultCommandLine.sumStringLength(labels) + labels.length * 2;
            String[] arguments = option.getArguments();
            DefaultCommandLine.print(stream, arguments, " ", " ");
            nb_characters = nb_characters + DefaultCommandLine.sumStringLength(arguments) + arguments.length;
            if (this.getAdditionalArguments()) {
                String[] add = new String[]{"[Additional]"};
                DefaultCommandLine.print(stream, add, " ", " ");
                nb_characters += DefaultCommandLine.sumStringLength(add) + add.length;
            }
            String[] description = option.getDescription();
            int i = 0;
            while (i < description.length) {
                int j = nb_characters;
                while (j <= this.maxOptionLength_) {
                    stream.print(' ');
                    ++j;
                }
                stream.println(description[i]);
                nb_characters = 0;
                ++i;
            }
        }
        stream.println("");
        stream.println("Description: ");
        DefaultCommandLine.print(stream, this.getDescription(), "  ", "\n  ");
        stream.println("\n");
    }

    public boolean isCheckingArguments() {
        return this.checkingArguments_;
    }

    public void setCheckingArguments(boolean checkingArguments) {
        this.checkingArguments_ = checkingArguments;
    }

    public Option[] getOptions() {
        return this.options_.toArray(new Option[0]);
    }

    public void addOption(Option option) {
        this.options_.addElement(option);
        int size = DefaultCommandLine.sumStringLength(option.getLabels()) + option.getLabels().length * 2 + DefaultCommandLine.sumStringLength(option.getArguments()) + option.getArguments().length;
        if (size > this.maxOptionLength_) {
            this.maxOptionLength_ = size;
        }
    }

    public String[] parse(String[] args) {
        DefaultIterator argumentsIterator = new DefaultIterator(args, this);
        block2: while (argumentsIterator.hasNext()) {
            String currentArgument = argumentsIterator.next();
            Iterator iterator = this.options_.iterator();
            while (iterator.hasNext()) {
                Option option = (Option)iterator.next();
                if (!option.check(currentArgument)) continue;
                argumentsIterator.remove();
                try {
                    option.consume(argumentsIterator);
                }
                catch (Error exc) {
                    this.exit(exc.getMessage() + " for option " + OptionHelper.toString(option));
                }
                continue block2;
            }
        }
        Iterator iterator = this.options_.iterator();
        while (iterator.hasNext()) {
            Option option = (Option)iterator.next();
            if (!option.isMandatory() || option.isSet()) continue;
            this.exit("Missed mandatory option " + OptionHelper.toString(option));
        }
        String[] arguments = argumentsIterator.getUnparsedArguments();
        if (this.isCheckingArguments()) {
            if (arguments.length < this.getArguments().length) {
                this.exit("Not enough arguments");
            }
            if (!this.getAdditionalArguments() && arguments.length > this.getArguments().length) {
                this.exit("Too many arguments");
            }
        }
        return arguments;
    }

    public Console getConsole() {
        return this.console_;
    }

    public void setConsole(Console console) {
        this.console_ = console;
    }
}

