/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.dumper;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.objectweb.fractal.adl.dumper.DomNodeFactory;
import org.objectweb.fractal.adl.dumper.util.AttributeUtil;
import org.objectweb.fractal.adl.dumper.util.Binding;
import org.objectweb.fractal.adl.dumper.util.BindingUtil;
import org.objectweb.fractal.adl.dumper.util.ComponentUtil;
import org.objectweb.fractal.adl.dumper.util.ContentUtil;
import org.objectweb.fractal.adl.dumper.util.InterfaceUtil;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.type.InterfaceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomAdlGenerator {
    public static final String STANDARD_DTD = "org/objectweb/fractal/adl/xml/standard.dtd";
    private Component defComp;
    private String dtd;
    protected DomNodeFactory factory;

    public DomAdlGenerator(String dtd) {
        this.dtd = dtd;
        if (dtd == null) {
            this.dtd = STANDARD_DTD;
        }
        this.factory = DomNodeFactory.getNodeFactory();
    }

    public Document generateDefinition(Component component) {
        this.defComp = component;
        Document doc = new Document(this.generateComponent(component).setName("definition"));
        DocType docType = new DocType("definition");
        docType.setPublicID("-//objectweb.org//DTD Fractal ADL 2.0//EN");
        docType.setSystemID("classpath://" + this.dtd);
        doc.setDocType(docType);
        return doc;
    }

    protected Element generateComponent(Component component) {
        Element componentElt = this.factory.createComponentNode(ComponentUtil.getName(component), null);
        componentElt.addContent(this.generateInterfaces(component));
        componentElt.addContent(this.generateContent(component));
        componentElt.addContent(this.generateAttributes(component));
        componentElt.addContent(this.generateBindings(component));
        componentElt.addContent((Content)this.generateController(component));
        return componentElt;
    }

    protected List<Element> generateBindings(Component component) {
        ArrayList<Element> bindingsElt = new ArrayList<Element>();
        if (ContentUtil.isComposite(component)) {
            Binding[] bindings = BindingUtil.getBindingsIn(component);
            for (int i = 0; i < bindings.length; ++i) {
                Element bindingNode = this.factory.createBindingNode(bindings[i].getClientItfName(component), bindings[i].getServerItfName(component));
                bindingsElt.add(bindingNode);
            }
        }
        return bindingsElt;
    }

    protected List<Element> generateAttributes(Component component) {
        ArrayList<Element> attributesElt = new ArrayList<Element>();
        Class[] attributesClasses = AttributeUtil.getAttributeControllerInterfaces(component);
        for (int i = 0; i < attributesClasses.length; ++i) {
            attributesElt.add(this.factory.createAttributesNode(attributesClasses[i].getName()));
            String[] attributes = AttributeUtil.getAttributesNames(component, attributesClasses[i]);
            for (int j = 0; j < attributes.length; ++j) {
                Element attributeElt = this.generateAttribute(component, attributes[j]);
                if (attributeElt == null) continue;
                ((Element)attributesElt.get(i)).addContent((Content)attributeElt);
            }
        }
        return attributesElt;
    }

    protected Element generateAttribute(Component component, String attribute) {
        if (component == null) {
            throw new IllegalArgumentException("Component parameter can't be null");
        }
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute parameter can't be null");
        }
        Object attr = AttributeUtil.getAttribute(component, attribute);
        if (attr != null) {
            return this.factory.createAttributeNode(attribute, attr.toString());
        }
        return null;
    }

    protected List<Element> generatePrimitiveContent(Component component) {
        ArrayList<Element> contentElt = new ArrayList<Element>();
        contentElt.add(this.factory.createContentNode(ContentUtil.getImplementation(component)));
        return contentElt;
    }

    protected List<Element> generateCompositeContent(Component component) {
        ArrayList<Element> contentElt = new ArrayList<Element>();
        Component[] children = ContentUtil.getSubComponents(component);
        for (int i = 0; i < children.length; ++i) {
            if (ContentUtil.isFirstParentOfSharedComp(children[i], component)) {
                contentElt.add(this.factory.createComponentNode(ComponentUtil.getName(children[i]), ComponentUtil.getOneRelativeNameWithoutTop(children[i], this.defComp)));
                continue;
            }
            contentElt.add(this.generateComponent(children[i]));
        }
        return contentElt;
    }

    protected List<Element> generateContent(Component component) {
        if (ContentUtil.isComposite(component)) {
            return this.generateCompositeContent(component);
        }
        return this.generatePrimitiveContent(component);
    }

    protected List<Element> generateInterfaces(Component component) {
        HashMap<String, Element> interfacesElt = new HashMap<String, Element>();
        Interface[] itfs = InterfaceUtil.getFunctionalItfs(component);
        for (int i = 0; i < itfs.length; ++i) {
            Element interfaceElement = this.generateInterface(itfs[i]);
            String itfName = interfaceElement.getAttributeValue("name");
            if (interfacesElt.containsKey(itfName)) continue;
            interfacesElt.put(itfName, interfaceElement);
        }
        return new ArrayList<Element>(interfacesElt.values());
    }

    protected Element generateInterface(Interface itf) {
        InterfaceType itfType = (InterfaceType)itf.getFcItfType();
        return this.factory.createInterfaceNode(itfType.getFcItfName(), !itfType.isFcClientItf(), itfType.getFcItfSignature(), itfType.isFcOptionalItf(), itfType.isFcCollectionItf());
    }

    protected Element generateController(Component component) {
        String description = null;
        try {
            description = component.getFcInterface("/controllerDesc").toString();
        }
        catch (NoSuchInterfaceException e) {
            description = ContentUtil.isComposite(component) ? "composite" : "primitive";
        }
        return this.factory.createControllerNode(description);
    }

    protected Element generateLifeCycle(Component component) {
        return this.factory.createLifeCycleNode(ComponentUtil.getLifeCycleState(component));
    }

    public void dump(Document doc, OutputStream os) {
        try {
            XMLOutputter outputter = new XMLOutputter();
            outputter.setFormat(Format.getPrettyFormat());
            outputter.output(doc, os);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void dump(Document doc, String path) {
        try {
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            String definition = doc.getRootElement().getAttribute("name").getValue();
            this.dump(doc, new FileOutputStream(path + "/" + definition + ".fractal"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void dump(Component component, String directory) {
        Document document = this.generateDefinition(component);
        this.dump(document, directory);
    }

    public String getDtd() {
        return this.dtd;
    }
}

