/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.dumper;

import org.jdom.Attribute;
import org.jdom.Element;

public class DomNodeFactory {
    private static DomNodeFactory factory = null;

    public static DomNodeFactory getNodeFactory() {
        if (factory == null) {
            return new DomNodeFactory();
        }
        return factory;
    }

    public Element createDefinitionNode(String name) {
        Element elt = new Element("definition");
        Attribute nameAtt = new Attribute("name", name);
        elt.setAttribute(nameAtt);
        return elt;
    }

    public Element createBindingNode(String client, String server) {
        Element elt = new Element("binding");
        Attribute clientAtt = new Attribute("client", client);
        Attribute serverAtt = new Attribute("server", server);
        elt.setAttribute(clientAtt);
        elt.setAttribute(serverAtt);
        return elt;
    }

    public Element createAttributeNode(String name, String value) {
        Element elt = new Element("attribute");
        Attribute nameAtt = new Attribute("name", name);
        Attribute valueAtt = new Attribute("value", value);
        elt.setAttribute(nameAtt);
        elt.setAttribute(valueAtt);
        return elt;
    }

    public Element createComponentNode(String name, String definition) {
        Element elt = new Element("component");
        Attribute nameAtt = new Attribute("name", name);
        elt.setAttribute(nameAtt);
        if (definition != null) {
            Attribute definitionAtt = new Attribute("definition", definition);
            elt.setAttribute(definitionAtt);
        }
        return elt;
    }

    public Element createInterfaceNode(String name, boolean isServer, String signature, boolean isOptional, boolean isCollection) {
        Element elt = new Element("interface");
        Attribute nameAtt = new Attribute("name", name);
        elt.setAttribute(nameAtt);
        Attribute roleAtt = new Attribute("role", isServer ? "server" : "client");
        elt.setAttribute(roleAtt);
        Attribute signatureAtt = new Attribute("signature", signature);
        elt.setAttribute(signatureAtt);
        if (isOptional) {
            Attribute contingencyAtt = new Attribute("contingency", "optional");
            elt.setAttribute(contingencyAtt);
        }
        if (isCollection) {
            Attribute cardinalityAtt = new Attribute("cardinality", "collection");
            elt.setAttribute(cardinalityAtt);
        }
        return elt;
    }

    public Element createContentNode(String clazz) {
        Element elt = new Element("content");
        Attribute classAtt = new Attribute("class", clazz);
        elt.setAttribute(classAtt);
        return elt;
    }

    public Element createAttributesNode(String signature) {
        Element elt = new Element("attributes");
        Attribute signatureAtt = new Attribute("signature", signature);
        elt.setAttribute(signatureAtt);
        return elt;
    }

    public Element createControllerNode(String description) {
        Element elt = new Element("controller");
        Attribute descAtt = new Attribute("desc", description);
        elt.setAttribute(descAtt);
        return elt;
    }

    public Element createLifeCycleNode(String state) {
        Element elt = new Element("lifecycle");
        Attribute stateAtt = new Attribute("state", state);
        elt.setAttribute(stateAtt);
        return elt;
    }
}

