/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.dumper;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.objectweb.fractal.adl.dumper.tasks.AdlTask;
import org.objectweb.fractal.adl.dumper.tasks.composite.ComponentTask;
import org.objectweb.fractal.adl.dumper.tasks.composite.ContentTask;
import org.objectweb.fractal.adl.dumper.tasks.composite.DefinitionTask;
import org.objectweb.fractal.adl.dumper.tasks.composite.ImplementationTask;
import org.objectweb.fractal.adl.dumper.tasks.composite.TypeTask;
import org.objectweb.fractal.adl.dumper.tasks.primitive.AttributesTask;
import org.objectweb.fractal.adl.dumper.tasks.primitive.BindingsTask;
import org.objectweb.fractal.adl.dumper.tasks.primitive.ComponentRefTask;
import org.objectweb.fractal.adl.dumper.tasks.primitive.ControllerTask;
import org.objectweb.fractal.adl.dumper.tasks.primitive.InterfacesTask;
import org.objectweb.fractal.adl.dumper.util.ComponentUtil;
import org.objectweb.fractal.adl.xml.XMLParser;
import org.objectweb.fractal.api.Component;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SaxAdlGenerator {
    public static final String STANDARD_DTD = "org/objectweb/fractal/adl/xml/standard.dtd";
    private String baseDir;
    private String prefix;
    private Component defComp;
    private static SaxAdlGenerator generator = null;
    private Map<String, ContentHandler> handlers;
    private ContentHandler hd;
    private boolean separated;
    private String dtd;
    private AdlTask task;

    public SaxAdlGenerator(String dtd, String path) {
        this(dtd);
        this.baseDir = path;
        if (!this.baseDir.endsWith("/")) {
            this.baseDir = this.baseDir + "/";
        }
    }

    public static SaxAdlGenerator getGenerator() {
        return generator;
    }

    public SaxAdlGenerator(String dtd) {
        this.dtd = dtd;
        if (dtd == null) {
            dtd = STANDARD_DTD;
        }
        this.baseDir = "";
        this.task = this.defineComponentTasks();
        this.hd = this.initHandler();
        generator = this;
    }

    public SaxAdlGenerator(String dtd, ContentHandler hd) throws SAXException {
        this(dtd);
        this.hd = hd;
        if (hd instanceof XMLParser) {
            ((XMLParser)hd).resolveEntity("-//objectweb.org//DTD Fractal ADL 2.0//EN", "classpath://" + this.dtd);
        }
    }

    public ContentHandler getContentHandler(String fileName) {
        ContentHandler handler = this.handlers.get(fileName);
        if (handler != null) {
            return handler;
        }
        handler = this.initHandler();
        this.handlers.put(fileName, handler);
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "utf-8");
            ((TransformerHandler)handler).setResult(new StreamResult(writer));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return handler;
    }

    protected ContentHandler initHandler() {
        try {
            SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            tf.setAttribute("indent-number", new Integer(2));
            TransformerHandler handler = tf.newTransformerHandler();
            Transformer serializer = handler.getTransformer();
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("method", "xml");
            serializer.setOutputProperty("doctype-public", "-//objectweb.org//DTD Fractal ADL 2.0//EN");
            serializer.setOutputProperty("doctype-system", "classpath://" + this.dtd);
            return handler;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected AdlTask defineComponentTasks() {
        ComponentTask componentTask = new ComponentTask();
        ContentTask contentTask = new ContentTask();
        contentTask.addTask(componentTask);
        componentTask.addTask(new InterfacesTask());
        componentTask.addTask(contentTask);
        componentTask.addTask(new AttributesTask());
        componentTask.addTask(new BindingsTask());
        componentTask.addTask(new ControllerTask());
        return componentTask;
    }

    protected AdlTask defineSeparatedComponentTasks() {
        TypeTask typeTask = new TypeTask();
        typeTask.addTask(new InterfacesTask());
        ContentTask contentTask = new ContentTask();
        ImplementationTask implementationTask = new ImplementationTask();
        implementationTask.addTask(contentTask);
        implementationTask.addTask(new AttributesTask());
        implementationTask.addTask(new BindingsTask());
        implementationTask.addTask(new ControllerTask());
        DefinitionTask definitionTask = new DefinitionTask();
        contentTask.addTask(new ComponentRefTask());
        contentTask.addTask(definitionTask);
        definitionTask.addTask(typeTask);
        definitionTask.addTask(implementationTask);
        return definitionTask;
    }

    public void generateDefinition(Component comp) {
        this.generateDefinition(comp, "", false);
    }

    public void generateDefinition(Component comp, boolean separated) {
        this.generateDefinition(comp, "", separated);
    }

    public void generateDefinition(Component comp, String prefix, boolean separated) {
        this.separated = separated;
        this.prefix = prefix;
        if (!prefix.equals("")) {
            this.prefix = this.prefix + ".";
        }
        this.defComp = comp;
        if (separated) {
            this.task = this.defineSeparatedComponentTasks();
            if (this.handlers == null) {
                this.handlers = new HashMap<String, ContentHandler>();
            }
        } else if (this.baseDir != null) {
            try {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.baseDir + ComponentUtil.getName(this.defComp) + ".fractal"), "utf-8");
                ((TransformerHandler)this.hd).setResult(new StreamResult(writer));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        this.task.generate(comp);
        if (separated) {
            this.handlers.clear();
        }
    }

    public ContentHandler getContentHandler() {
        return this.hd;
    }

    public String getDtd() {
        return this.dtd;
    }

    public boolean isSeparated() {
        return this.separated;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public Component getDefComp() {
        return this.defComp;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

