/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.dumper.tasks.composite;

import org.objectweb.fractal.adl.dumper.SaxAdlGenerator;
import org.objectweb.fractal.adl.dumper.tasks.composite.CompositeTask;
import org.objectweb.fractal.adl.dumper.util.ComponentUtil;
import org.objectweb.fractal.adl.dumper.util.ContentUtil;
import org.objectweb.fractal.api.Component;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ContentTask
extends CompositeTask {
    protected void generateCompositeContent(Component comp, ContentHandler hd) {
        Component[] children = ContentUtil.getSubComponents(comp);
        for (int i = 0; i < children.length; ++i) {
            if (ContentUtil.isFirstParentOfSharedComp(children[i], comp)) {
                this.generateSharedContent(ComponentUtil.getName(children[i]), ComponentUtil.getOneRelativeNameWithoutTop(children[i], SaxAdlGenerator.getGenerator().getDefComp()), hd);
                continue;
            }
            if (SaxAdlGenerator.getGenerator().isSeparated()) {
                this.execute(children[i], hd);
                continue;
            }
            this.execute(children[i]);
        }
    }

    protected void generatePrimitiveContent(Component comp, ContentHandler hd) {
        try {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "", "class", "CDATA", ContentUtil.getImplementation(comp));
            hd.startElement("", "", "content", atts);
            hd.endElement("", "", "content");
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    protected void generateSharedContent(String name, String definition, ContentHandler hd) {
        try {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "", "name", "CDATA", name);
            atts.addAttribute("", "", "definition", "CDATA", definition);
            hd.startElement("", "", "component", atts);
            hd.endElement("", "", "component");
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return "content";
    }

    public void generate(Component comp, ContentHandler hd) {
        if (ContentUtil.isComposite(comp)) {
            this.generateCompositeContent(comp, hd);
        } else {
            this.generatePrimitiveContent(comp, hd);
        }
    }

    public boolean isType() {
        return false;
    }
}

