/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.dumper.tasks.primitive;

import org.objectweb.fractal.adl.dumper.tasks.primitive.PrimitiveTask;
import org.objectweb.fractal.adl.dumper.util.AttributeUtil;
import org.objectweb.fractal.api.Component;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class AttributesTask
extends PrimitiveTask {
    protected void generateAttribute(Component component, String attribute, ContentHandler hd) {
        try {
            AttributesImpl atts = new AttributesImpl();
            Object attributeObject = AttributeUtil.getAttribute(component, attribute);
            if (attributeObject != null) {
                atts.addAttribute("", "", "name", "CDATA", attribute);
                atts.addAttribute("", "", "value", "CDATA", attributeObject.toString());
                hd.startElement("", "", "attribute", atts);
                hd.endElement("", "", "attribute");
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return "attributes";
    }

    public void generate(Component comp, ContentHandler hd) {
        try {
            AttributesImpl atts = new AttributesImpl();
            Class[] attributesClasses = AttributeUtil.getAttributeControllerInterfaces(comp);
            for (int i = 0; i < attributesClasses.length; ++i) {
                atts.clear();
                atts.addAttribute("", "", "signature", "CDATA", attributesClasses[i].getName());
                hd.startElement("", "", "attributes", atts);
                String[] attributes = AttributeUtil.getAttributesNames(comp, attributesClasses[i]);
                for (int j = 0; j < attributes.length; ++j) {
                    this.generateAttribute(comp, attributes[j], hd);
                }
                hd.endElement("", "", "attributes");
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public boolean isType() {
        return false;
    }
}

