/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.dumper.tasks.primitive;

import java.util.HashSet;
import org.objectweb.fractal.adl.dumper.tasks.primitive.PrimitiveTask;
import org.objectweb.fractal.adl.dumper.util.InterfaceUtil;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.type.InterfaceType;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class InterfacesTask
extends PrimitiveTask {
    protected void generateInterface(Interface itf, ContentHandler hd) {
        InterfaceType itfType = (InterfaceType)itf.getFcItfType();
        this.generateInterface(itfType.getFcItfName(), !itfType.isFcClientItf(), ((InterfaceType)itf.getFcItfType()).getFcItfSignature(), itfType.isFcOptionalItf(), itfType.isFcCollectionItf(), hd);
    }

    protected void generateInterface(String name, boolean isServer, String signature, boolean isOptional, boolean isCollection, ContentHandler hd) {
        try {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "", "name", "CDATA", name);
            atts.addAttribute("", "", "role", "CDATA", isServer ? "server" : "client");
            atts.addAttribute("", "", "signature", "CDATA", signature);
            if (isCollection) {
                atts.addAttribute("", "", "cardinality", "CDATA", "collection");
            }
            if (isOptional) {
                atts.addAttribute("", "", "contingency", "CDATA", "optional");
            }
            hd.startElement("", "", "interface", atts);
            hd.endElement("", "", "interface");
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return "interfaces";
    }

    public void generate(Component comp, ContentHandler hd) {
        HashSet<String> itfNames = new HashSet<String>();
        Interface[] itfs = InterfaceUtil.getFunctionalItfs(comp);
        for (int i = 0; i < itfs.length; ++i) {
            String itfName = ((InterfaceType)itfs[i].getFcItfType()).getFcItfName();
            if (!itfNames.add(itfName)) continue;
            this.generateInterface(itfs[i], hd);
        }
    }

    public boolean isType() {
        return true;
    }
}

