/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.dumper.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.objectweb.fractal.adl.dumper.util.Binding;
import org.objectweb.fractal.adl.dumper.util.ContentUtil;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.SuperController;
import org.objectweb.fractal.util.Fractal;

public class BindingUtil {
    public static List getClientBindings(Component comp) {
        BindingController bindingcontroller = null;
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        try {
            bindingcontroller = Fractal.getBindingController((Component)comp);
            String[] clientItfs = bindingcontroller.listFc();
            for (int i = 0; i < clientItfs.length; ++i) {
                Interface clientItf = (Interface)comp.getFcInterface(clientItfs[i]);
                Interface serverItf = (Interface)bindingcontroller.lookupFc(clientItfs[i]);
                if (serverItf == null) continue;
                bindings.add(new Binding(clientItf, serverItf));
            }
        }
        catch (NoSuchInterfaceException e) {
            return null;
        }
        return bindings;
    }

    public static Binding[] getBindingsIn(Component comp) {
        String compName = null;
        ContentController contentcontroller = null;
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        try {
            compName = Fractal.getNameController((Component)comp).getFcName();
            List parent = BindingUtil.getClientBindings(comp);
            Iterator it = parent.listIterator();
            while (it.hasNext()) {
                Binding binding = (Binding)it.next();
                Component serverOwner = binding.getServerItf().getFcItfOwner();
                if (!binding.getClientItfOwnerName().equals(compName) || !ContentUtil.isSubcomponent(serverOwner, comp)) continue;
                bindings.add(binding);
            }
            contentcontroller = Fractal.getContentController((Component)comp);
            Component[] subcomps = contentcontroller.getFcSubComponents();
            for (int i = 0; i < subcomps.length; ++i) {
                List children = BindingUtil.getClientBindings(subcomps[i]);
                if (children == null) continue;
                for (Binding binding : children) {
                    Component clientOwner = binding.getClientItf().getFcItfOwner();
                    Component serverOwner = binding.getServerItf().getFcItfOwner();
                    if (binding.getServerItfOwnerName().equals(compName)) {
                        if (!ContentUtil.isSubcomponent(subcomps[i], comp)) continue;
                        bindings.add(binding);
                        continue;
                    }
                    if (ContentUtil.isSubcomponent(serverOwner, clientOwner)) continue;
                    bindings.add(binding);
                }
            }
        }
        catch (NoSuchInterfaceException e) {
            e.printStackTrace();
        }
        return bindings.toArray(new Binding[bindings.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isLocalBinding(Interface cItf, Component cId, Interface sItf, Component sId) {
        Component[] cP;
        Component server;
        Component client = cItf.getFcItfOwner();
        if (client.equals(server = sItf.getFcItfOwner())) {
            return true;
        }
        SuperController cSc = null;
        SuperController sSc = null;
        try {
            cSc = (SuperController)client.getFcInterface("super-controller");
        }
        catch (NoSuchInterfaceException ignored) {
            // empty catch block
        }
        try {
            sSc = (SuperController)server.getFcInterface("super-controller");
        }
        catch (NoSuchInterfaceException ignored) {
            // empty catch block
        }
        if (cItf.isFcInternalItf()) {
            if (cSc == null) return true;
            Component[] sP = sSc.getFcSuperComponents();
            for (int i = 0; i < sP.length; ++i) {
                Component p = sP[i];
                if (sId != null && p.equals(sId) || !p.equals(client)) continue;
                return true;
            }
            return false;
        } else if (sItf.isFcInternalItf()) {
            if (cSc == null) return true;
            cP = cSc.getFcSuperComponents();
            for (int i = 0; i < cP.length; ++i) {
                Component p = cP[i];
                if (cId != null && p.equals(cId) || !p.equals(server)) continue;
                return true;
            }
            return false;
        } else {
            if (cSc == null || sSc == null) return true;
            cP = cSc.getFcSuperComponents();
            Component[] sP = sSc.getFcSuperComponents();
            for (int i = 0; i < cP.length; ++i) {
                Component p = cP[i];
                if (cId != null && p.equals(cId)) continue;
                for (int j = 0; j < sP.length; ++j) {
                    Component q = sP[j];
                    if (sId != null && q.equals(sId) || !p.equals(q)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

