/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.dumper.util;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.fractal.adl.dumper.util.ContentUtil;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.NameController;
import org.objectweb.fractal.api.control.SuperController;
import org.objectweb.fractal.util.Fractal;

public class ComponentUtil {
    public static List toplevels = new ArrayList();

    public static String getName(Component comp) {
        try {
            return Fractal.getNameController((Component)comp).getFcName();
        }
        catch (NoSuchInterfaceException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getOneAbsoluteName(Component comp) {
        StringBuffer str = new StringBuffer();
        ComponentUtil.toString(comp, str);
        if (str != null) {
            return str.toString();
        }
        return null;
    }

    public static String getOneRelativeName(Component child, Component parent) {
        String path = "";
        try {
            Component[] parents = Fractal.getContentController((Component)parent).getFcSubComponents();
            for (int i = 0; i < parents.length; ++i) {
                if (ComponentUtil.getName(child).equals(ComponentUtil.getName(parent))) {
                    return ComponentUtil.getName(child);
                }
                String result = ComponentUtil.getOneRelativeName(child, parents[i]);
                if (result == null) continue;
                path = path + result;
                break;
            }
        }
        catch (NoSuchInterfaceException e) {
            if (ComponentUtil.getName(child).equals(ComponentUtil.getName(parent))) {
                return ComponentUtil.getName(child);
            }
            return null;
        }
        if (!path.equals("")) {
            return ComponentUtil.getName(parent) + "/" + path;
        }
        return null;
    }

    public static String getOneRelativeNameWithoutTop(Component child, Component parent) {
        return ComponentUtil.getOneRelativeName(child, parent).substring(ComponentUtil.getName(parent).length() + 1);
    }

    public static String getDefinitionName(Component comp, Component parentComp) {
        if (ContentUtil.isShared(comp) && !ComponentUtil.getName(ContentUtil.getParents(comp)[0]).equals(ComponentUtil.getName(parentComp))) {
            return ComponentUtil.getName(ContentUtil.getParents(comp)[0]) + "/" + ComponentUtil.getName(comp);
        }
        return ComponentUtil.getName(comp);
    }

    public static String getLifeCycleState(Component component) {
        try {
            return Fractal.getLifeCycleController((Component)component).getFcState();
        }
        catch (NoSuchInterfaceException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Component getComponent(Component parent, String name) {
        try {
            Component[] children = Fractal.getContentController((Component)parent).getFcSubComponents();
            for (int i = 0; i < children.length; ++i) {
                String comp = Fractal.getNameController((Component)children[i]).getFcName();
                if (!comp.equals(name)) continue;
                return children[i];
            }
        }
        catch (NoSuchInterfaceException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean registerToplevel(Component component) {
        if (ComponentUtil.isTopLevel(component)) {
            toplevels.add(component);
            return true;
        }
        return false;
    }

    public static boolean unregisterTopLevel(Component component) {
        return toplevels.remove(component);
    }

    public static Component findToplevel(String name) {
        try {
            for (Component comp : toplevels) {
                String compName = Fractal.getNameController((Component)comp).getFcName();
                if (!compName.equals(name)) continue;
                return comp;
            }
        }
        catch (NoSuchInterfaceException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Component getComponent(String fullName) {
        String[] path = fullName.split("/");
        Component parent = ComponentUtil.findToplevel(path[0]);
        for (int i = 1; i < path.length; ++i) {
            Component comp;
            parent = comp = ComponentUtil.getComponent(parent, path[i]);
        }
        return parent;
    }

    public static boolean isTopLevel(Component component) {
        Component[] parents = null;
        try {
            parents = Fractal.getSuperController((Component)component).getFcSuperComponents();
        }
        catch (NoSuchInterfaceException e) {
            e.printStackTrace();
        }
        return parents.length == 0;
    }

    public static boolean isStopped(Component component) {
        try {
            return Fractal.getLifeCycleController((Component)component).getFcState().equals("STOPPED");
        }
        catch (NoSuchInterfaceException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static List getAllParentsList(Component comp) {
        ArrayList parents = new ArrayList();
        try {
            SuperController sc = Fractal.getSuperController((Component)comp);
            Component[] components = sc.getFcSuperComponents();
            for (int i = 0; i < components.length; ++i) {
                parents.addAll(ComponentUtil.getAllParentsList(components[i]));
            }
        }
        catch (NoSuchInterfaceException e) {
            e.printStackTrace();
        }
        return parents;
    }

    public static Component[] getAllParents(Component comp) {
        List parents = ComponentUtil.getAllParentsList(comp);
        return parents.toArray(new Component[parents.size()]);
    }

    public static void toString(Component component, StringBuffer buf) {
        try {
            NameController nc = (NameController)component.getFcInterface("name-controller");
            try {
                SuperController sc = (SuperController)component.getFcInterface("super-controller");
                Component[] superComponents = sc.getFcSuperComponents();
                if (superComponents.length > 0) {
                    ComponentUtil.toString(superComponents[0], buf);
                }
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {
                // empty catch block
            }
            buf.append('/');
            buf.append(nc.getFcName());
        }
        catch (NoSuchInterfaceException e) {
            buf.append(component.toString());
            return;
        }
    }
}

