/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.dumper.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.util.Fractal;

public class InterfaceUtil {
    public String getItfFullName(Interface itf) {
        try {
            String ownerName = Fractal.getNameController((Component)itf.getFcItfOwner()).getFcName();
            return ownerName + "." + itf.getFcItfName();
        }
        catch (NoSuchInterfaceException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getRole(Interface itf) {
        if (((InterfaceType)itf.getFcItfType()).isFcClientItf()) {
            return "client";
        }
        return "server";
    }

    public static String getCardinality(Interface itf) {
        if (((InterfaceType)itf.getFcItfType()).isFcCollectionItf()) {
            return "collection";
        }
        return "singleton";
    }

    public static String getContingency(Interface itf) {
        if (((InterfaceType)itf.getFcItfType()).isFcOptionalItf()) {
            return "optional";
        }
        return "mandatory";
    }

    public static Interface[] getControllerItfs(Component comp) {
        Object[] itfs = comp.getFcInterfaces();
        ArrayList<Object> controllers = new ArrayList<Object>();
        for (int i = 0; i < itfs.length; ++i) {
            String itfName = ((Interface)itfs[i]).getFcItfName();
            if (!itfName.endsWith("controller") && !itfName.equals("component")) continue;
            controllers.add(itfs[i]);
        }
        return controllers.toArray(new Interface[controllers.size()]);
    }

    public static Interface[] getFunctionalItfs(Component comp) {
        Object[] itfs = comp.getFcInterfaces();
        ArrayList<Object> functions = new ArrayList<Object>();
        for (int i = 0; i < itfs.length; ++i) {
            String itfName = ((Interface)itfs[i]).getFcItfName();
            if (itfName.endsWith("controller") || itfName.equals("component")) continue;
            functions.add(itfs[i]);
        }
        return functions.toArray(new Interface[functions.size()]);
    }

    public static Interface[] getFunctionalServerItfs(Component comp) {
        Interface[] itfs = InterfaceUtil.getFunctionalItfs(comp);
        ArrayList<Interface> funcItfs = new ArrayList<Interface>();
        for (int i = 0; i < itfs.length; ++i) {
            if (((InterfaceType)itfs[i].getFcItfType()).isFcClientItf()) continue;
            funcItfs.add(itfs[i]);
        }
        return funcItfs.toArray(new Interface[funcItfs.size()]);
    }

    public static Interface[] getFunctionalClientItfs(Component comp) {
        Interface[] itfs = InterfaceUtil.getFunctionalItfs(comp);
        ArrayList<Interface> funcItfs = new ArrayList<Interface>();
        for (int i = 0; i < itfs.length; ++i) {
            if (!((InterfaceType)itfs[i].getFcItfType()).isFcClientItf()) continue;
            funcItfs.add(itfs[i]);
        }
        return funcItfs.toArray(new Interface[funcItfs.size()]);
    }

    public boolean isBound() {
        return false;
    }

    public static boolean isBound(Interface itf) {
        Component owner = itf.getFcItfOwner();
        boolean isClient = ((InterfaceType)itf.getFcItfType()).isFcClientItf();
        if (isClient) {
            Object res = null;
            try {
                res = Fractal.getBindingController((Component)owner).lookupFc(itf.getFcItfName());
            }
            catch (NoSuchInterfaceException e) {
                e.printStackTrace();
            }
            return res != null;
        }
        return false;
    }

    public static boolean isClientItf(Interface itf) {
        return ((InterfaceType)itf.getFcItfType()).isFcClientItf();
    }

    public static boolean isCompItf(Component comp, String itf) {
        try {
            comp.getFcInterface(itf);
        }
        catch (NoSuchInterfaceException e) {
            return false;
        }
        return true;
    }

    public static boolean isSubTypeOf(Interface serverItf, Interface clientItf) {
        return ((InterfaceType)serverItf).isFcSubTypeOf(clientItf.getFcItfType());
    }

    public static boolean isSubTypeOf(Interface serverItf, Component clientComp, String clientItfName) {
        try {
            return InterfaceUtil.isSubTypeOf(serverItf, (Interface)clientComp.getFcInterface(clientItfName));
        }
        catch (NoSuchInterfaceException e) {
            return false;
        }
    }

    public static Method[] getMethods(Interface itf) {
        ArrayList<Method> ops = new ArrayList<Method>();
        Class<?>[] itfs = itf.getClass().getInterfaces();
        for (int i = 0; i < itfs.length; ++i) {
            if (itfs[i].getName().equals("Generated")) continue;
            Method[] meths = itfs[i].getMethods();
            for (int j = 0; j < meths.length; ++j) {
                ops.add(meths[j]);
            }
        }
        return ops.toArray(new Method[ops.size()]);
    }

    public static Method getMethod(Interface itf, String methodName) {
        Class<?>[] itfs = itf.getClass().getInterfaces();
        for (int i = 0; i < itfs.length; ++i) {
            Method[] meths;
            if (itfs[i].getName().equals("Generated") || !(meths = itfs[i].getMethods())[i].getName().equals(methodName)) continue;
            return meths[i];
        }
        return null;
    }
}

