/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.asm;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.fractal.julia.asm.ClassGenerationException;
import org.objectweb.fractal.julia.asm.CodeGenerator;
import org.objectweb.fractal.julia.asm.InterceptorClassGenerator;
import org.objectweb.fractal.julia.loader.Initializable;
import org.objectweb.fractal.julia.loader.Tree;

public abstract class MetaCodeGenerator
implements Initializable,
CodeGenerator,
Opcodes {
    private Tree args;
    private InterceptorClassGenerator icg;
    private String delegateFieldName;
    private String delegateFieldDesc;
    private String owner;
    private MethodVisitor clinit;
    private int counter;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$reflect$Method;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$org$objectweb$fractal$julia$InitializationContext;

    public void initialize(Tree args) {
        this.args = args.getSubTree(0);
    }

    public int init(InterceptorClassGenerator icg) {
        this.icg = icg;
        return 0;
    }

    public void generateInitCode(MethodVisitor cv) throws ClassGenerationException {
        String owner = null;
        int i = 0;
        while (i < this.icg.controllerClasses.length) {
            Class c = this.icg.controllerClasses[i];
            ArrayList<Class> params = new ArrayList<Class>();
            if (this.reifyInterfaceName()) {
                params.add(class$java$lang$String == null ? MetaCodeGenerator.class$("java.lang.String") : class$java$lang$String);
            }
            if (this.reifyTargetObject()) {
                params.add(class$java$lang$Object == null ? MetaCodeGenerator.class$("java.lang.Object") : class$java$lang$Object);
            }
            params.add(class$java$lang$reflect$Method == null ? MetaCodeGenerator.class$("java.lang.reflect.Method") : class$java$lang$reflect$Method);
            params.add(array$Ljava$lang$Object == null ? MetaCodeGenerator.class$("[Ljava.lang.Object;") : array$Ljava$lang$Object);
            Class[] paramClasses = params.toArray(new Class[params.size()]);
            try {
                c.getMethod(this.getHandleMethodCallMethodName(), paramClasses);
                owner = c.getName();
                break;
            }
            catch (Exception e) {
                ++i;
            }
        }
        if (owner == null) {
            throw new ClassGenerationException(null, this.icg.args.toString(), "Cannot find a controller class providing a '" + this.getHandleMethodCallMethodName() + "' method with the good arguments");
        }
        owner = owner.replace('.', '/');
        int hashcode = this.getControllerInterfaceName().hashCode();
        this.delegateFieldName = "d" + Integer.toHexString(hashcode);
        this.delegateFieldDesc = "L" + owner + ";";
        FieldVisitor fv = this.icg.cw.visitField(2, this.delegateFieldName, this.delegateFieldDesc, null, null);
        if (fv != null) {
            fv.visitEnd();
        }
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, 1);
        cv.visitLdcInsn((Object)this.getControllerInterfaceName());
        cv.visitMethodInsn(182, Type.getInternalName((Class)(class$org$objectweb$fractal$julia$InitializationContext == null ? (class$org$objectweb$fractal$julia$InitializationContext = MetaCodeGenerator.class$("org.objectweb.fractal.julia.InitializationContext")) : class$org$objectweb$fractal$julia$InitializationContext)), "getInterface", "(" + Type.getDescriptor((Class)(class$java$lang$String == null ? (class$java$lang$String = MetaCodeGenerator.class$("java.lang.String")) : class$java$lang$String)) + ")" + Type.getDescriptor((Class)(class$java$lang$Object == null ? (class$java$lang$Object = MetaCodeGenerator.class$("java.lang.Object")) : class$java$lang$Object)));
        cv.visitTypeInsn(192, owner);
        cv.visitFieldInsn(181, this.icg.name, this.delegateFieldName, this.delegateFieldDesc);
    }

    public MethodVisitor generateInterceptionCode(Method m, MethodVisitor cv) {
        if (this.intercept(m)) {
            return new MetaCodeAdapter(cv, m);
        }
        return cv;
    }

    public void generateCloneCode(MethodVisitor cv) {
        cv.visitVarInsn(25, 1);
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, this.icg.name, this.delegateFieldName, this.delegateFieldDesc);
        cv.visitFieldInsn(181, this.icg.name, this.delegateFieldName, this.delegateFieldDesc);
    }

    public void close() {
        if (this.clinit != null) {
            this.clinit.visitInsn(177);
            this.clinit.visitMaxs(0, 0);
        }
    }

    protected abstract String getControllerInterfaceName();

    protected boolean intercept(Method m) {
        return true;
    }

    protected abstract String getHandleMethodCallMethodName();

    protected boolean reifyInterfaceName() {
        return false;
    }

    private String getInterfaceName(Method m) {
        if (this.args != null) {
            String desc = m.getName() + Type.getMethodDescriptor((Method)m);
            List itfs = this.icg.interfaces;
            int i = 0;
            while (i < itfs.size()) {
                block6: {
                    Class c;
                    String itf = ((String)itfs.get(i)).replace('/', '.');
                    try {
                        c = this.icg.loader.loadClass(itf, (Object)this.icg.classLoader);
                    }
                    catch (ClassNotFoundException e) {
                        break block6;
                    }
                    Method[] meths = c.getMethods();
                    int j = 0;
                    while (j < meths.length) {
                        Method meth = meths[j];
                        if (desc.equals(meth.getName() + Type.getMethodDescriptor((Method)meth))) {
                            return this.args.getSubTree(i).toString();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    protected boolean reifyTargetObject() {
        return false;
    }

    protected abstract String getIsReflectedCallMethodName();

    public static void generateMethodInitializerCode(Method m, String owner, String field, ClassVisitor cv, MethodVisitor mv) {
        FieldVisitor fv = cv.visitField(10, field, "Ljava/lang/reflect/Method;", null, null);
        if (fv != null) {
            fv.visitEnd();
        }
        mv.visitLdcInsn((Object)m.getDeclaringClass().getName());
        mv.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
        mv.visitLdcInsn((Object)m.getName());
        Class<?>[] formals = m.getParameterTypes();
        mv.visitIntInsn(17, formals.length);
        mv.visitTypeInsn(189, "java/lang/Class");
        int i = 0;
        while (i < formals.length) {
            mv.visitInsn(89);
            mv.visitIntInsn(17, i);
            Class<?> c = formals[i];
            if (c.isPrimitive()) {
                String type = c == Byte.TYPE ? "java/lang/Byte" : (c == Integer.TYPE ? "java/lang/Integer" : (c == Boolean.TYPE ? "java/lang/Boolean" : (c == Double.TYPE ? "java/lang/Double" : (c == Float.TYPE ? "java/lang/Float" : (c == Long.TYPE ? "java/lang/Long" : (c == Character.TYPE ? "java/lang/Character" : "java/lang/Short"))))));
                mv.visitFieldInsn(178, type, "TYPE", "Ljava/lang/Class;");
            } else {
                String name = c.isArray() ? Type.getDescriptor(c).replace('/', '.') : c.getName();
                mv.visitLdcInsn((Object)name);
                mv.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
            }
            mv.visitInsn(83);
            ++i;
        }
        mv.visitMethodInsn(182, "java/lang/Class", "getMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
        mv.visitFieldInsn(179, owner, field, "Ljava/lang/reflect/Method;");
    }

    public static void generateParameterReifierCode(Method m, MethodVisitor cv) {
        Class<?>[] params = m.getParameterTypes();
        cv.visitIntInsn(17, params.length);
        cv.visitTypeInsn(189, "java/lang/Object");
        int localVarIndex = 1;
        int i = 0;
        while (i < params.length) {
            Class<?> param = params[i];
            cv.visitInsn(89);
            cv.visitIntInsn(17, i);
            if (param.isPrimitive()) {
                String desc;
                String type;
                int opcode = 21;
                if (param == Byte.TYPE) {
                    type = "java/lang/Byte";
                    desc = "B";
                } else if (param == Integer.TYPE) {
                    type = "java/lang/Integer";
                    desc = "I";
                } else if (param == Boolean.TYPE) {
                    type = "java/lang/Boolean";
                    desc = "Z";
                } else if (param == Double.TYPE) {
                    opcode = 24;
                    type = "java/lang/Double";
                    desc = "D";
                } else if (param == Float.TYPE) {
                    opcode = 23;
                    type = "java/lang/Float";
                    desc = "F";
                } else if (param == Long.TYPE) {
                    opcode = 22;
                    type = "java/lang/Long";
                    desc = "J";
                } else if (param == Character.TYPE) {
                    type = "java/lang/Character";
                    desc = "C";
                } else {
                    type = "java/lang/Short";
                    desc = "S";
                }
                cv.visitTypeInsn(187, type);
                cv.visitInsn(89);
                cv.visitVarInsn(opcode, localVarIndex);
                cv.visitMethodInsn(183, type, "<init>", "(" + desc + ")V");
            } else {
                cv.visitVarInsn(25, localVarIndex);
            }
            cv.visitInsn(83);
            localVarIndex += param == Double.TYPE || param == Long.TYPE ? 2 : 1;
            ++i;
        }
    }

    public static void generateReturnCode(Method m, MethodVisitor cv) {
        Class<?> result = m.getReturnType();
        if (result == Void.TYPE) {
            cv.visitInsn(87);
            cv.visitInsn(177);
        } else if (result.isPrimitive()) {
            String desc;
            String meth;
            String type;
            int opcode = 172;
            if (result == Byte.TYPE) {
                type = "java/lang/Byte";
                meth = "byteValue";
                desc = "B";
            } else if (result == Integer.TYPE) {
                type = "java/lang/Integer";
                meth = "intValue";
                desc = "I";
            } else if (result == Boolean.TYPE) {
                type = "java/lang/Boolean";
                meth = "booleanValue";
                desc = "Z";
            } else if (result == Double.TYPE) {
                opcode = 175;
                type = "java/lang/Double";
                meth = "doubleValue";
                desc = "D";
            } else if (result == Float.TYPE) {
                opcode = 174;
                type = "java/lang/Float";
                meth = "floatValue";
                desc = "F";
            } else if (result == Long.TYPE) {
                opcode = 173;
                type = "java/lang/Long";
                meth = "longValue";
                desc = "J";
            } else if (result == Character.TYPE) {
                type = "java/lang/Character";
                meth = "charValue";
                desc = "C";
            } else {
                type = "java/lang/Short";
                meth = "shortValue";
                desc = "S";
            }
            cv.visitTypeInsn(192, type);
            cv.visitMethodInsn(182, type, meth, "()" + desc);
            cv.visitInsn(opcode);
        } else {
            cv.visitTypeInsn(192, Type.getInternalName(result));
            cv.visitInsn(176);
        }
    }

    public List getImplementedInterfaces() throws ClassGenerationException {
        return new ArrayList();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MetaCodeAdapter
    implements MethodVisitor {
        private final MethodVisitor cv;
        private final boolean mergeAll;

        public MetaCodeAdapter(MethodVisitor cv, Method m) {
            this.cv = cv;
            this.mergeAll = ((MetaCodeGenerator)MetaCodeGenerator.this).icg.mergeAll;
            if (MetaCodeGenerator.this.owner == null) {
                if (MetaCodeGenerator.this.delegateFieldDesc == null) {
                    MetaCodeGenerator.this.owner = ((MetaCodeGenerator)MetaCodeGenerator.this).icg.name;
                } else {
                    MetaCodeGenerator.this.owner = MetaCodeGenerator.this.delegateFieldDesc.substring(1, MetaCodeGenerator.this.delegateFieldDesc.length() - 1);
                }
            }
            Label endLabel = null;
            if (this.mergeAll) {
                cv.visitVarInsn(25, 0);
                cv.visitMethodInsn(182, MetaCodeGenerator.this.owner, MetaCodeGenerator.this.getIsReflectedCallMethodName(), "()Z");
                endLabel = new Label();
                cv.visitJumpInsn(154, endLabel);
            }
            cv.visitVarInsn(25, 0);
            if (MetaCodeGenerator.this.delegateFieldName != null) {
                cv.visitFieldInsn(180, ((MetaCodeGenerator)MetaCodeGenerator.this).icg.name, MetaCodeGenerator.this.delegateFieldName, MetaCodeGenerator.this.delegateFieldDesc);
            }
            if (MetaCodeGenerator.this.clinit == null) {
                MetaCodeGenerator.this.clinit = ((MetaCodeGenerator)MetaCodeGenerator.this).icg.cw.visitMethod(8, "<clinit>", "()V", null, null);
                MetaCodeGenerator.this.clinit.visitCode();
            }
            MetaCodeGenerator.generateMethodInitializerCode(m, ((MetaCodeGenerator)MetaCodeGenerator.this).icg.name, "_M" + MetaCodeGenerator.this.counter, (ClassVisitor)((MetaCodeGenerator)MetaCodeGenerator.this).icg.cw, MetaCodeGenerator.this.clinit);
            if (MetaCodeGenerator.this.reifyInterfaceName()) {
                String name = MetaCodeGenerator.this.getInterfaceName(m);
                if (name == null) {
                    cv.visitInsn(1);
                } else {
                    cv.visitLdcInsn((Object)name);
                }
            }
            if (MetaCodeGenerator.this.reifyTargetObject()) {
                cv.visitVarInsn(25, 0);
                cv.visitFieldInsn(180, ((MetaCodeGenerator)MetaCodeGenerator.this).icg.name, ((MetaCodeGenerator)MetaCodeGenerator.this).icg.implFieldName, ((MetaCodeGenerator)MetaCodeGenerator.this).icg.implFieldDesc);
            }
            cv.visitFieldInsn(178, ((MetaCodeGenerator)MetaCodeGenerator.this).icg.name, "_M" + MetaCodeGenerator.this.counter, "Ljava/lang/reflect/Method;");
            MetaCodeGenerator.generateParameterReifierCode(m, cv);
            String desc = "Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;";
            if (MetaCodeGenerator.this.reifyTargetObject()) {
                desc = "Ljava/lang/Object;" + desc;
            }
            if (MetaCodeGenerator.this.reifyInterfaceName()) {
                desc = "Ljava/lang/String;" + desc;
            }
            cv.visitMethodInsn(182, MetaCodeGenerator.this.owner, MetaCodeGenerator.this.getHandleMethodCallMethodName(), "(" + desc);
            MetaCodeGenerator.generateReturnCode(m, cv);
            if (this.mergeAll) {
                cv.visitLabel(endLabel);
            } else {
                cv.visitMaxs(0, 0);
            }
            cv.visitEnd();
            ++MetaCodeGenerator.this.counter;
        }

        public void visitInsn(int opcode) {
            if (this.mergeAll) {
                this.cv.visitInsn(opcode);
            }
        }

        public void visitIntInsn(int opcode, int operand) {
            if (this.mergeAll) {
                this.cv.visitIntInsn(opcode, operand);
            }
        }

        public void visitVarInsn(int opcode, int var) {
            if (this.mergeAll) {
                this.cv.visitVarInsn(opcode, var);
            }
        }

        public void visitTypeInsn(int opcode, String desc) {
            if (this.mergeAll) {
                this.cv.visitTypeInsn(opcode, desc);
            }
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (this.mergeAll) {
                this.cv.visitFieldInsn(opcode, owner, name, desc);
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (this.mergeAll) {
                this.cv.visitMethodInsn(opcode, owner, name, desc);
            }
        }

        public void visitJumpInsn(int opcode, Label label) {
            if (this.mergeAll) {
                this.cv.visitJumpInsn(opcode, label);
            }
        }

        public void visitLabel(Label label) {
            if (this.mergeAll) {
                this.cv.visitLabel(label);
            }
        }

        public void visitLdcInsn(Object cst) {
            if (this.mergeAll) {
                this.cv.visitLdcInsn(cst);
            }
        }

        public void visitIincInsn(int var, int increment) {
            if (this.mergeAll) {
                this.cv.visitIincInsn(var, increment);
            }
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
            if (this.mergeAll) {
                this.cv.visitTableSwitchInsn(min, max, dflt, labels);
            }
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            if (this.mergeAll) {
                this.cv.visitLookupSwitchInsn(dflt, keys, labels);
            }
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            if (this.mergeAll) {
                this.cv.visitMultiANewArrayInsn(desc, dims);
            }
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            if (this.mergeAll) {
                this.cv.visitTryCatchBlock(start, end, handler, type);
            }
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            if (this.mergeAll) {
                this.cv.visitMaxs(maxStack, maxLocals);
            }
        }

        public void visitAttribute(Attribute attribute) {
            this.cv.visitAttribute(attribute);
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            if (this.mergeAll) {
                this.cv.visitLocalVariable(name, desc, null, start, end, index);
            }
        }

        public void visitCode() {
            this.cv.visitCode();
        }

        public void visitLineNumber(int line, Label start) {
            if (this.mergeAll) {
                this.cv.visitLineNumber(line, start);
            }
        }

        public void visitEnd() {
            this.cv.visitEnd();
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return this.cv.visitAnnotationDefault();
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return this.cv.visitAnnotation(desc, visible);
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            return this.cv.visitParameterAnnotation(parameter, desc, visible);
        }

        public void visitFrame(int arg0, int arg1, Object[] arg2, int arg3, Object[] arg4) {
        }
    }
}

