/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.plugin.java.reflect;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.objectweb.util.explorer.plugin.java.reflect.ClassVisibilityConfig;
import org.objectweb.util.explorer.swing.gui.api.ValidateReport;
import org.objectweb.util.explorer.swing.gui.lib.AbstractElementBox;
import org.objectweb.util.explorer.swing.gui.lib.DefaultValidateReport;

public class ClassVisibilityBox
extends AbstractElementBox {
    protected ClassVisibilityConfig oldConfig_;
    protected ClassVisibilityConfig newConfig_;

    public ClassVisibilityBox() {
        this(null);
    }

    public ClassVisibilityBox(ClassVisibilityConfig config) {
        super(true);
        this.oldConfig_ = config != null ? config : new ClassVisibilityConfig();
        this.newConfig_ = (ClassVisibilityConfig)this.oldConfig_.clone();
        Box mainBox = Box.createVerticalBox();
        Box treeInheritanceBox = Box.createHorizontalBox();
        treeInheritanceBox.add(Box.createHorizontalGlue());
        JPanel treeInheritancePanel = this.createHorizontalPanel("Tree Inheritance");
        treeInheritancePanel.add(this.createCheckBox("Tree inheritance", "tree-inheritance"));
        treeInheritancePanel.add(this.createCheckBox("Flat view", "flat-view"));
        treeInheritanceBox.add(treeInheritancePanel);
        treeInheritanceBox.add(Box.createHorizontalGlue());
        mainBox.add(treeInheritanceBox);
        mainBox.add(Box.createVerticalStrut(10));
        Box classVisibilityBox = Box.createHorizontalBox();
        classVisibilityBox.add(Box.createHorizontalGlue());
        JPanel attributesPanel = this.createVerticalPanel("Attributes");
        attributesPanel.add(this.createCheckBox("public", "attribute.public"));
        attributesPanel.add(this.createCheckBox("protected", "attribute.protected"));
        attributesPanel.add(this.createCheckBox("private", "attribute.private"));
        attributesPanel.add(this.createCheckBox("package", "attribute.package"));
        attributesPanel.add(this.createCheckBox("static", "attribute.static"));
        attributesPanel.add(this.createCheckBox("final", "attribute.final"));
        attributesPanel.add(this.createCheckBox("display the type", "attribute.type"));
        attributesPanel.add(this.createCheckBox("display declaring class", "attribute.declaring-class"));
        classVisibilityBox.add(attributesPanel);
        classVisibilityBox.add(Box.createHorizontalStrut(10));
        JPanel methodsPanel = this.createVerticalPanel("Methods");
        methodsPanel.add(this.createCheckBox("public", "method.public"));
        methodsPanel.add(this.createCheckBox("protected", "method.protected"));
        methodsPanel.add(this.createCheckBox("private", "method.private"));
        methodsPanel.add(this.createCheckBox("package", "method.package"));
        methodsPanel.add(this.createCheckBox("static", "method.static"));
        methodsPanel.add(this.createCheckBox("final", "method.final"));
        methodsPanel.add(this.createCheckBox("abstract", "method.abstract"));
        methodsPanel.add(this.createCheckBox("display the params", "method.params"));
        methodsPanel.add(this.createCheckBox("display the return type", "method.return-type"));
        methodsPanel.add(this.createCheckBox("display declaring class", "method.declaring-class"));
        classVisibilityBox.add(methodsPanel);
        classVisibilityBox.add(Box.createHorizontalStrut(10));
        JPanel innerClassPanel = this.createVerticalPanel("Inner Classes");
        innerClassPanel.add(this.createCheckBox("public", "inner_class.public"));
        innerClassPanel.add(this.createCheckBox("protected", "inner_class.protected"));
        innerClassPanel.add(this.createCheckBox("private", "inner_class.private"));
        innerClassPanel.add(this.createCheckBox("package", "inner_class.package"));
        innerClassPanel.add(this.createCheckBox("static", "inner_class.static"));
        innerClassPanel.add(this.createCheckBox("final", "inner_class.final"));
        innerClassPanel.add(this.createCheckBox("abstract", "inner_class.abstract"));
        innerClassPanel.add(this.createCheckBox("display declaring class", "inner_class.declaring-class"));
        classVisibilityBox.add(innerClassPanel);
        classVisibilityBox.add(Box.createHorizontalGlue());
        mainBox.add(classVisibilityBox);
        this.add(mainBox);
    }

    protected JPanel createVerticalPanel(String title) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(title));
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentY(0.0f);
        panel.setAlignmentX(0.0f);
        return panel;
    }

    protected JPanel createHorizontalPanel(String title) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(title));
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setAlignmentY(0.0f);
        panel.setAlignmentX(0.0f);
        return panel;
    }

    protected JCheckBox createCheckBox(String label, String name) {
        JCheckBox checkBox = new JCheckBox(label);
        checkBox.setSelected(this.newConfig_.get(name));
        checkBox.addItemListener(new ChangeState(name, checkBox));
        return checkBox;
    }

    public ValidateReport validateBox() {
        return new DefaultValidateReport();
    }

    public ClassVisibilityConfig getConfig() {
        return this.newConfig_;
    }

    private final class ChangeState
    implements ItemListener {
        protected String state_;
        protected JCheckBox checkBox_;

        public ChangeState(String state, JCheckBox checkBox) {
            this.state_ = state;
            this.checkBox_ = checkBox;
        }

        public void itemStateChanged(ItemEvent e) {
            ClassVisibilityBox.this.newConfig_.put(this.state_, this.checkBox_.isSelected());
        }
    }
}

