/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.plugin.java.reflect.swing;

import java.awt.Color;
import java.awt.FlowLayout;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import org.objectweb.util.explorer.api.Panel;
import org.objectweb.util.explorer.api.TreeView;
import org.objectweb.util.explorer.plugin.java.reflect.ClassUtil;
import org.objectweb.util.explorer.plugin.java.reflect.ClassVisibility;
import org.objectweb.util.explorer.plugin.java.reflect.ClassVisibilityConfig;
import org.objectweb.util.explorer.plugin.java.reflect.FieldUtil;
import org.objectweb.util.explorer.plugin.java.reflect.MemberComparator;
import org.objectweb.util.explorer.plugin.java.reflect.MethodUtil;

public class ClassPanel
implements Panel {
    protected JPanel panel_ = new JPanel();
    protected StringBuffer htmlText_ = new StringBuffer();
    protected MemberComparator comparator_;

    public ClassPanel() {
        FlowLayout flow = new FlowLayout(0);
        this.panel_.setLayout(flow);
        this.panel_.setBackground(Color.white);
        this.comparator_ = new MemberComparator();
    }

    protected String[] getFields(Field[] fields, ClassVisibilityConfig config) {
        Arrays.sort(fields, this.comparator_);
        Vector<String> fieldList = new Vector<String>();
        FieldUtil fieldUtil = null;
        for (int i = 0; i < fields.length; ++i) {
            if (!ClassVisibility.hasToBeAdded(fields[i].getModifiers(), config, "attribute")) continue;
            fieldUtil = new FieldUtil(fields[i]);
            fieldList.add(fieldUtil.toHTML());
        }
        return fieldList.toArray(new String[0]);
    }

    protected String[] getMethods(Method[] methods, ClassVisibilityConfig config) {
        Arrays.sort(methods, this.comparator_);
        Vector<String> methodList = new Vector<String>();
        MethodUtil methodUtil = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!ClassVisibility.hasToBeAdded(methods[i].getModifiers(), config, "method")) continue;
            methodUtil = new MethodUtil(methods[i]);
            methodList.add(methodUtil.toHTML());
        }
        return methodList.toArray(new String[0]);
    }

    protected String[] getInnerClasses(Class[] classes, ClassVisibilityConfig config) {
        Arrays.sort(classes, this.comparator_);
        Vector<String> classList = new Vector<String>();
        ClassUtil classUtil = null;
        for (int i = 0; i < classes.length; ++i) {
            if (!ClassVisibility.hasToBeAdded(classes[i].getModifiers(), config, "inner_class")) continue;
            classUtil = new ClassUtil(classes[i]);
            classList.add(classUtil.toHTML());
        }
        return classList.toArray(new String[0]);
    }

    protected String getHTMLList(String[] elements) {
        if (elements != null) {
            StringBuffer list = new StringBuffer();
            list.append("<ul>");
            for (int i = 0; i < elements.length; ++i) {
                list.append("<li>" + elements[i] + "</li>");
            }
            list.append("</ul>");
            return list.toString();
        }
        return "";
    }

    public Object getPanel() {
        return this.panel_;
    }

    public void selected(TreeView treeView) {
        String[] innerClasses;
        String[] methods;
        Class theClass = (Class)treeView.getSelectedObject();
        ClassVisibilityConfig config = (ClassVisibilityConfig)ClassVisibility.config_.get(theClass.getName());
        if (config == null) {
            config = (ClassVisibilityConfig)ClassVisibility.config_.get("_default_config_");
        }
        this.htmlText_.append("<html>");
        this.htmlText_.append("<header></header>");
        this.htmlText_.append("<body>");
        String name = theClass.getName();
        String package_ = theClass.isPrimitive() ? "" : (name.lastIndexOf(46) == -1 ? "" : name.substring(0, name.lastIndexOf(46)));
        String type = theClass.isInterface() ? "Interface " : "Class ";
        String className = name.lastIndexOf(46) == -1 ? name : name.substring(name.lastIndexOf(46) + 1);
        this.htmlText_.append(package_);
        this.htmlText_.append("<h2>" + type + " " + className + "</h2>");
        this.htmlText_.append("<hr width=\"50%\"><br>");
        String[] fields = this.getFields(theClass.getDeclaredFields(), config);
        if (fields.length > 0) {
            this.htmlText_.append("<b>Fields</b>");
            this.htmlText_.append(this.getHTMLList(fields));
        }
        if ((methods = this.getMethods(theClass.getDeclaredMethods(), config)).length > 0) {
            this.htmlText_.append("<b>Methods</b>");
            this.htmlText_.append(this.getHTMLList(methods));
        }
        if ((innerClasses = this.getInnerClasses(theClass.getDeclaredClasses(), config)).length > 0) {
            this.htmlText_.append("<b>Inner classes</b>");
            this.htmlText_.append(this.getHTMLList(innerClasses));
        }
        this.htmlText_.append("</body>");
        this.htmlText_.append("</html>");
        JEditorPane html = new JEditorPane("text/html", this.htmlText_.toString());
        html.setEditable(false);
        this.panel_.add(html);
    }

    public void unselected(TreeView treeview) {
    }
}

