/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.apollon.gui;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileReader;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.objectweb.apollon.framework.Bean;
import org.objectweb.apollon.gui.ApollonMenuBar;
import org.objectweb.apollon.gui.ApollonSplitPane;
import org.objectweb.util.browser.core.common.DynamicTree;

public class ApollonFrame
extends JFrame {
    private ApollonSplitPane split_content_;
    private Properties extensions_table = new Properties();

    public ApollonFrame() {
        this.setJMenuBar(new ApollonMenuBar(this));
        this.setDefaultCloseOperation(3);
        this.setTitle(System.getProperty("apollon.gui.title"));
    }

    public DynamicTree getTree() {
        return this.split_content_.getTree();
    }

    public void set_split_panel(ApollonSplitPane split_panel) {
        this.split_content_ = split_panel;
        if (System.getProperty("apollon.generated.frameworks") == null) {
            System.err.println("No framework found -> no XML files will be usable. Check the apollon.generated.framework Java property");
        } else {
            StringTokenizer all_extensions_frameworks = new StringTokenizer(System.getProperty("apollon.generated.frameworks"), ",");
            while (all_extensions_frameworks.hasMoreTokens()) {
                String used_framework = all_extensions_frameworks.nextToken();
                String extension = used_framework.substring(0, used_framework.indexOf(">"));
                String framework = used_framework.substring(used_framework.indexOf(">") + 1);
                this.extensions_table.put(extension, framework);
                this.split_content_.add_browser_config(framework.replace('.', '/') + "/browser/xml/browser_configuration.xml");
            }
        }
        if (System.getProperty("browser.configuration.file") != null) {
            this.split_content_.add_browser_config(System.getProperty("browser.configuration.file"));
        } else {
            System.err.println("WARNING: no provided custom config for browser");
        }
        this.getContentPane().add(this.split_content_);
        this.pack();
        this.split_content_.setDividerLocation(this.getWidth() / 2);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2);
    }

    public String getPackage_by_filename(String file_name) {
        String file_type = file_name.substring(file_name.lastIndexOf(".") + 1).toLowerCase();
        if (this.extensions_table.getProperty(file_type) != null) {
            return this.extensions_table.getProperty(file_type);
        }
        return "";
    }

    public void newToWorkbench() {
        File file = null;
        JFileChooser dialogBox = new JFileChooser(System.getProperty("user.dir"));
        int returnVal = dialogBox.showOpenDialog(new JPanel());
        if (returnVal != 0) {
            return;
        }
        file = dialogBox.getSelectedFile().getAbsoluteFile();
        if (this.getPackage_by_filename(file.getName()).equals("")) {
            System.err.println("[Apollon] File :" + file.getName() + " : not a descriptor, skipped");
            return;
        }
        String framework_package = this.getPackage_by_filename(file.getName());
        String root_name = framework_package.substring(framework_package.lastIndexOf(".") + 1);
        Bean zeusInstance = null;
        try {
            zeusInstance = (Bean)Class.forName(framework_package + ".beans." + root_name.substring(0, 1).toUpperCase() + root_name.substring(1).toLowerCase() + "BeanImpl").newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (System.getProperty("apollon.newfiles.dtd.dir") != null) {
            zeusInstance.setDocType(root_name, "", System.getProperty("apollon.newfiles.dtd.dir") + "/" + root_name + ".dtd");
        } else {
            System.err.println("WARNING: no provided DTD directory. Leaving XML file without doctype...");
        }
        try {
            zeusInstance.marshalBean(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.add_xml_file(file, framework_package + ".beans." + root_name.substring(0, 1).toUpperCase() + root_name.substring(1).toLowerCase() + "BeanImpl");
    }

    public void openDialog() {
        File file = null;
        JFileChooser dialogBox = new JFileChooser(System.getProperty("user.dir"));
        int returnVal = dialogBox.showOpenDialog(new JPanel());
        if (returnVal != 0) {
            return;
        }
        file = dialogBox.getSelectedFile().getAbsoluteFile();
        this.open_file(file);
    }

    public void close_file(String file_id) {
        this.split_content_.remove_file_from_table(file_id);
    }

    public void open_file(File file) {
        try {
            if (this.getPackage_by_filename(file.getName()).equals("")) {
                System.err.println("File : " + file.getName() + " : no framework found handling this file extension");
                return;
            }
            String framework_package = this.getPackage_by_filename(file.getName());
            String root_name = framework_package.substring(framework_package.lastIndexOf(".") + 1);
            this.add_xml_file(file, framework_package + ".beans." + root_name.substring(0, 1).toUpperCase() + root_name.substring(1).toLowerCase() + "BeanImpl");
        }
        catch (Exception exc) {
            System.err.println("*** error during file opening ***");
            exc.printStackTrace();
        }
    }

    public void add_xml_file(File xml_file, String unmarshaller) {
        Bean zeusInstance = null;
        try {
            Class<?> reader = Class.forName(unmarshaller);
            FileReader fileReader = new FileReader(xml_file);
            Object[] parameters = new Object[]{xml_file};
            Class[] parameterTypes = new Class[]{xml_file.getClass()};
            zeusInstance = (Bean)reader.getMethod("unmarshalBean", parameterTypes).invoke(null, parameters);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.split_content_.add_instance_to_tree(zeusInstance, xml_file);
    }

    public void saveAllWorkbench() {
        this.split_content_.save_edited_files();
    }
}

