/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.apollon.gui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import org.objectweb.apollon.framework.Bean;
import org.objectweb.apollon.framework.Context;
import org.objectweb.util.browser.api.Entry;
import org.objectweb.util.browser.core.api.ViewPanel;
import org.objectweb.util.browser.core.common.DefaultTreePanel;
import org.objectweb.util.browser.core.common.DefaultViewPanel;
import org.objectweb.util.browser.core.common.DynamicTree;

public class ApollonSplitPane
extends JSplitPane {
    private DynamicTree tree_;
    private DefaultViewPanel view_panel_ = new DefaultViewPanel();
    private static Hashtable files_table;
    List browser_files_;

    public ApollonSplitPane() {
        super(1, true);
        this.tree_ = new DynamicTree();
        this.tree_.setTargetPanel((ViewPanel)this.view_panel_);
        this.setLeftComponent((Component)new DefaultTreePanel((JTree)this.tree_));
        this.setRightComponent((Component)this.view_panel_);
        files_table = new Hashtable();
        this.browser_files_ = new LinkedList();
    }

    public DynamicTree getTree() {
        return this.tree_;
    }

    public void add_file_to_table(String file_id, String file_path) {
        files_table.put(file_id, file_path);
    }

    public void remove_file_from_table(String file_id) {
        files_table.remove(file_id);
    }

    public void add_instance_to_tree(Bean instance, File file) {
        String identifier = file.getName();
        while (true) {
            if (!files_table.containsKey(identifier)) break;
            identifier = identifier + "_";
        }
        this.add_file_to_table(identifier, file.getAbsolutePath());
        this.tree_.addEntry((Object)identifier, (Object)instance, 0);
    }

    public void save_edited_files() {
        org.objectweb.util.browser.api.Context content = this.tree_.getInitialContext();
        Entry[] contained_entries = content.getEntries();
        for (int i = 0; i < contained_entries.length; ++i) {
            this.save_tree_entry(contained_entries[i]);
        }
    }

    public void save_tree_entry(Entry tree_entry) {
        Bean xml_instance = ((Context)tree_entry.getValue()).getSource();
        String file_path = (String)files_table.get(tree_entry.getName());
        try {
            xml_instance.marshalBean(new File(file_path));
        }
        catch (IOException exception) {
            System.err.println("Save failed for " + tree_entry.getName());
            exception.printStackTrace();
        }
    }

    public void add_browser_config(String directory_to_use) {
        this.browser_files_.add(directory_to_use);
        this.tree_.setNewBrowserProperty(this.browser_files_.toArray(new String[0]));
    }

    public static String get_file_by_id(String file_id) {
        return (String)files_table.get(file_id);
    }
}

