/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.objectweb.util.explorer.core.common.lib.ClassResolver;
import org.objectweb.util.trace.TraceSystem;

public abstract class ExplorerUtils {
    protected static Object[] merge(Object[] a1, Object[] a2) {
        List<Object> l;
        List<Object> list = l = a1 == null ? new Vector() : Arrays.asList(a1);
        if (a2 != null && a2.length > 0) {
            l = new Vector<Object>(l);
            for (int i = 0; i < a2.length; ++i) {
                if (l.contains(a2[i])) continue;
                l.add(a2[i]);
            }
        }
        return l.toArray();
    }

    public static Object[] mergeArrays(Object[] a1, Object[] a2) {
        return ExplorerUtils.merge(a1, a2);
    }

    public static String[] mergeArrays(String[] a1, String[] a2) {
        Object[] result = ExplorerUtils.merge(a1, a2);
        return Arrays.asList(result).toArray(new String[result.length]);
    }

    public static String arrayToString(Object[] m) {
        if (m != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("{");
            for (int i = 0; i < m.length; ++i) {
                sb.append(m[i]);
                if (i >= m.length - 1) continue;
                sb.append(",");
            }
            sb.append("}");
            return sb.toString();
        }
        return "null";
    }

    public static boolean compareObjects(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null) {
            return o1.equals(o2);
        }
        return false;
    }

    public static int getHashCode(Object o) {
        if (o != null) {
            return o.hashCode();
        }
        return 0;
    }

    public static String toString(Object o) {
        return o == null ? "null" : o.toString();
    }

    public static boolean isEmpty(String value) {
        return value == null || value.equals("");
    }

    public static URL getURL(String url) {
        try {
            URL theURL = ClassResolver.getResource(url);
            if (theURL == null) {
                theURL = new URL(url);
            }
            return theURL;
        }
        catch (MalformedURLException e) {
            TraceSystem.get((String)"explorer").info(url + ": Resource not found!");
            return null;
        }
    }
}

