/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.contextConfig;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.objectweb.util.explorer.contextConfig.Context;
import org.objectweb.util.explorer.contextConfig.ContextDefaultErrorHandler;
import org.objectweb.util.explorer.contextConfig.ContextImpl;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;

public class ContextUnmarshaller {
    private static EntityResolver entityResolver;
    private static ErrorHandler errorHandler;

    public static void setEntityResolver(EntityResolver resolver) {
        entityResolver = resolver;
    }

    public static void setErrorHandler(ErrorHandler handler) {
        errorHandler = handler;
    }

    public static Context unmarshal(File file) throws IOException {
        return ContextUnmarshaller.unmarshal(new FileReader(file));
    }

    public static Context unmarshal(File file, boolean validate) throws IOException {
        return ContextUnmarshaller.unmarshal(new FileReader(file), validate);
    }

    public static Context unmarshal(InputStream inputStream) throws IOException {
        return ContextUnmarshaller.unmarshal(new InputStreamReader(inputStream));
    }

    public static Context unmarshal(InputStream inputStream, boolean validate) throws IOException {
        return ContextUnmarshaller.unmarshal(new InputStreamReader(inputStream), validate);
    }

    public static Context unmarshal(Reader reader) throws IOException {
        String property = System.getProperty("org.enhydra.zeus.validation", "false");
        boolean validationState = false;
        if (property.equalsIgnoreCase("true")) {
            validationState = true;
        }
        return ContextUnmarshaller.unmarshal(reader, validationState);
    }

    public static Context unmarshal(Reader reader, boolean validate) throws IOException {
        if (entityResolver != null) {
            ContextImpl.setEntityResolver(entityResolver);
        }
        if (errorHandler != null) {
            ContextImpl.setErrorHandler(errorHandler);
        } else if (validate) {
            ContextImpl.setErrorHandler(new ContextDefaultErrorHandler());
        }
        return ContextImpl.unmarshal(reader, validate);
    }
}

