/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.core.menu.lib;

import java.util.List;
import java.util.Vector;
import org.objectweb.util.explorer.ExplorerUtils;
import org.objectweb.util.explorer.core.menu.api.ItemDescription;
import org.objectweb.util.explorer.core.menu.api.MenuDescription;
import org.objectweb.util.explorer.core.menu.api.MenuElement;
import org.objectweb.util.explorer.core.menu.api.MnemonicDescription;
import org.objectweb.util.explorer.core.menu.lib.BasicMenuSeparator;

public class BasicMenuDescription
implements MenuDescription {
    protected boolean inheritTreeMenu_ = true;
    protected boolean inheritTypeMenu_ = true;
    protected String label_ = null;
    protected MnemonicDescription mnemonicDesc_;
    protected List menuElements_ = new Vector();
    protected List childMenuElements_ = new Vector();
    protected String descriptionType_ = "menu";

    protected boolean equals(BasicMenuDescription menuDesc) {
        if (menuDesc != null) {
            return ExplorerUtils.compareObjects(this.menuElements_, menuDesc.menuElements_) && ExplorerUtils.compareObjects(this.childMenuElements_, menuDesc.childMenuElements_);
        }
        return false;
    }

    public String getDescriptionType() {
        return this.descriptionType_;
    }

    public boolean isEmpty() {
        return this.menuElements_.isEmpty() && this.childMenuElements_.isEmpty();
    }

    public void setDescriptionType(String descriptionType) {
        this.descriptionType_ = descriptionType;
    }

    public void setInheritTreeMenu(boolean inheritTreeMenu) {
        this.inheritTreeMenu_ = inheritTreeMenu;
    }

    public boolean getInheritTreeMenu() {
        return this.inheritTreeMenu_;
    }

    public void setInheritTypeMenu(boolean inheritTypeMenu) {
        this.inheritTypeMenu_ = inheritTypeMenu;
    }

    public boolean getInheritTypeMenu() {
        return this.inheritTypeMenu_;
    }

    public String getLabel() {
        return this.label_;
    }

    public void setLabel(String label) {
        this.label_ = label;
    }

    public MnemonicDescription getMnemonicDescription() {
        return this.mnemonicDesc_;
    }

    public void setMnemonicDescription(MnemonicDescription mnemonicDescription) {
        this.mnemonicDesc_ = mnemonicDescription;
    }

    public void addMenuElement(MenuElement menuElement) {
        if (menuElement != null && !menuElement.isEmpty()) {
            if (menuElement instanceof ItemDescription) {
                List theList;
                ItemDescription itemDesc = (ItemDescription)menuElement;
                List list = theList = itemDesc.getTreeChildVisible() ? this.childMenuElements_ : this.menuElements_;
                if (!theList.contains(itemDesc)) {
                    theList.add(menuElement);
                }
            } else {
                this.menuElements_.add(menuElement);
            }
        }
    }

    public void addMenuElements(MenuElement[] menuElements) {
        if (menuElements != null) {
            for (int i = 0; i < menuElements.length; ++i) {
                this.addMenuElement(menuElements[i]);
            }
        }
    }

    public MenuElement[] getMenuElements() {
        return this.menuElements_.toArray(new MenuElement[this.menuElements_.size()]);
    }

    public MenuElement[] getChildrenMenuElements() {
        return this.childMenuElements_.toArray(new MenuElement[this.childMenuElements_.size()]);
    }

    public MenuElement[] getAllMenuElements() {
        MenuElement[] menuElement = this.getMenuElements();
        MenuElement[] childrenMenuElement = this.getChildrenMenuElements();
        boolean needSeparator = menuElement.length > 0 && childrenMenuElement.length > 0;
        MenuElement[] mergeMenu = new MenuElement[menuElement.length + childrenMenuElement.length + (needSeparator ? 1 : 0)];
        System.arraycopy(menuElement, 0, mergeMenu, 0, menuElement.length);
        if (needSeparator) {
            mergeMenu[menuElement.length] = new BasicMenuSeparator();
        }
        System.arraycopy(childrenMenuElement, 0, mergeMenu, menuElement.length + (needSeparator ? 1 : 0), childrenMenuElement.length);
        return mergeMenu;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof BasicMenuDescription) {
            return this.equals((BasicMenuDescription)o);
        }
        return false;
    }

    public String toString() {
        return "BasicMenuDescription[inheritTreeMenu=" + this.inheritTreeMenu_ + ", " + "inheritTypeMenu=" + this.inheritTypeMenu_ + ", " + "mnemonicDesc=" + ExplorerUtils.toString(this.mnemonicDesc_) + ", " + "menuElements=" + ExplorerUtils.arrayToString(this.menuElements_.toArray()) + "childMenuElements=" + ExplorerUtils.arrayToString(this.childMenuElements_.toArray()) + "]";
    }
}

