/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.core.role;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.objectweb.util.explorer.ExplorerUtils;
import org.objectweb.util.explorer.core.role.api.Role;
import org.objectweb.util.explorer.core.role.api.RoleDescription;
import org.objectweb.util.explorer.core.role.lib.DefaultRoleDescription;
import org.objectweb.util.explorer.core.role.lib.RoleProperty;

public class RolePropertyTest
extends TestCase {
    protected RoleDescription r0;
    protected RoleDescription r0bis;
    protected RoleDescription r1;
    protected RoleDescription r2;
    protected RoleDescription r3;
    protected RoleDescription r4;
    protected RoleDescription r5;
    protected RoleDescription r6;
    protected RoleDescription r7;
    protected RoleDescription r8;
    protected RoleDescription r9;
    protected RoleDescription r10;
    protected RoleDescription r11;
    protected RoleDescription r12;
    protected RoleProperty roleProperty_ = null;

    protected RoleDescription createRoleDesc(String id, String[] inheritedRoles, boolean concrete) {
        DefaultRoleDescription r = new DefaultRoleDescription();
        r.setId(id);
        r.setConcrete(concrete);
        r.setInheritance(inheritedRoles);
        return r;
    }

    protected RoleDescription createRoleDesc(String id, String[] inheritedRoles) {
        return this.createRoleDesc(id, inheritedRoles, true);
    }

    protected void feedRoleDesc(RoleDescription[] roles) {
        for (int i = 0; i < roles.length; ++i) {
            this.roleProperty_.feed(roles[i]);
        }
    }

    protected void checkTreeInheritance(String[] roleIds, String[] expectedRolesIds) {
        Object[] expectedRoles = this.roleProperty_.getRoles(expectedRolesIds);
        Object[] resultRoles = this.roleProperty_.getRoles(this.roleProperty_.getInheritedRoleIds(roleIds));
        String result = ExplorerUtils.arrayToString(resultRoles);
        String expected = ExplorerUtils.arrayToString(expectedRoles);
        Assert.assertEquals((String)expected, (String)result);
    }

    protected void setUp() throws Exception {
        this.r0 = this.createRoleDesc("0", new String[]{"1"});
        this.r1 = this.createRoleDesc("1", new String[]{"3"});
        this.r2 = this.createRoleDesc("2", new String[]{"4", "5"});
        this.r3 = this.createRoleDesc("3", new String[]{"6", "10"});
        this.r4 = this.createRoleDesc("4", new String[]{"7"});
        this.r5 = this.createRoleDesc("5", new String[]{"8", "9"});
        this.r6 = this.createRoleDesc("6", new String[0]);
        this.r7 = this.createRoleDesc("7", new String[]{"10", "11"});
        this.r8 = this.createRoleDesc("8", null);
        this.r9 = this.createRoleDesc("9", new String[]{"12"});
        this.r10 = this.createRoleDesc("10", new String[0]);
        this.r11 = this.createRoleDesc("11", new String[0]);
        this.r12 = this.createRoleDesc("12", null);
        this.r0bis = this.createRoleDesc("0", new String[]{"1", "4", "2", "1"});
        this.roleProperty_ = new RoleProperty();
    }

    public void testConcreteRole() {
        this.feedRoleDesc(new RoleDescription[]{this.r0, this.r0bis});
        Role r = this.roleProperty_.getRole("0");
        Assert.assertTrue((boolean)r.isConcrete());
    }

    public void testMultipleDefinition() {
        this.feedRoleDesc(new RoleDescription[]{this.r0, this.r0bis, this.r1, this.r2, this.r4});
        this.checkTreeInheritance(new String[]{"0"}, new String[]{"0", "1", "4", "2"});
    }

    public void testInheritanceTree() {
        this.feedRoleDesc(new RoleDescription[]{this.r0, this.r0bis, this.r1, this.r2, this.r3, this.r4, this.r5, this.r6, this.r7, this.r8, this.r9, this.r10, this.r11, this.r12});
        this.checkTreeInheritance(new String[]{"0"}, new String[]{"0", "1", "4", "2", "3", "7", "5", "6", "10", "11", "8", "9", "12"});
        this.checkTreeInheritance(new String[]{"1", "5"}, new String[]{"1", "5", "3", "8", "9", "6", "10", "12"});
    }

    public void testInfiniteLoop() {
        RoleDescription role0 = this.createRoleDesc("0", new String[]{"1"});
        RoleDescription role1 = this.createRoleDesc("1", new String[]{"3"});
        RoleDescription role2 = this.createRoleDesc("2", new String[]{"1"});
        RoleDescription role3 = this.createRoleDesc("3", new String[]{"2"});
        this.feedRoleDesc(new RoleDescription[]{role0, role1, role2, role3});
        this.checkTreeInheritance(new String[]{"0"}, new String[]{"0", "1", "3", "2"});
        this.checkTreeInheritance(new String[]{"1"}, new String[]{"1", "3", "2"});
    }
}

