/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.explorerConfig;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.objectweb.util.explorer.explorerConfig.Accelerator;
import org.objectweb.util.explorer.explorerConfig.AcceleratorImpl;
import org.objectweb.util.explorer.explorerConfig.Code;
import org.objectweb.util.explorer.explorerConfig.CodeImpl;
import org.objectweb.util.explorer.explorerConfig.Icon;
import org.objectweb.util.explorer.explorerConfig.IconImpl;
import org.objectweb.util.explorer.explorerConfig.Item;
import org.objectweb.util.explorer.explorerConfig.Mnemonic;
import org.objectweb.util.explorer.explorerConfig.MnemonicImpl;
import org.objectweb.util.explorer.explorerConfig.Unmarshallable;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ItemImpl
extends DefaultHandler
implements Cloneable,
Unmarshallable,
LexicalHandler,
Item {
    private Icon icon;
    private Accelerator accelerator;
    private Mnemonic mnemonic;
    private Code code;
    private String treeChildVisible = "false";
    private static boolean zeus_TreeChildVisibleInitialized;
    private static Vector zeus_validTreeChildVisible;
    private boolean zeus_TreeChildVisibleSet;
    private String label;
    private boolean zeus_LabelSet;
    private String typeChildVisible;
    private static boolean zeus_TypeChildVisibleInitialized;
    private static Vector zeus_validTypeChildVisible;
    private boolean zeus_TypeChildVisibleSet;
    private String docTypeString;
    private String outputEncoding;
    private Unmarshallable zeus_currentUNode;
    private Unmarshallable zeus_parentUNode;
    private boolean zeus_thisNodeHandled = false;
    private boolean hasDTD;
    private boolean validate;
    private Map namespaceMappings;
    private static EntityResolver entityResolver;
    private static ErrorHandler errorHandler;
    private static ItemImpl prototype;

    public static void setPrototype(ItemImpl prototype) {
        ItemImpl.prototype = prototype;
    }

    public static ItemImpl newInstance() {
        try {
            return prototype != null ? (ItemImpl)prototype.clone() : new ItemImpl();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public ItemImpl() {
        zeus_TreeChildVisibleInitialized = false;
        zeus_validTreeChildVisible = null;
        this.zeus_TreeChildVisibleSet = false;
        this.zeus_LabelSet = false;
        this.typeChildVisible = "true";
        zeus_TypeChildVisibleInitialized = false;
        zeus_validTypeChildVisible = null;
        this.zeus_TypeChildVisibleSet = false;
        this.docTypeString = "";
        this.hasDTD = false;
        this.validate = false;
        this.namespaceMappings = new HashMap();
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Accelerator getAccelerator() {
        return this.accelerator;
    }

    public void setAccelerator(Accelerator accelerator) {
        this.accelerator = accelerator;
    }

    public Mnemonic getMnemonic() {
        return this.mnemonic;
    }

    public void setMnemonic(Mnemonic mnemonic) {
        this.mnemonic = mnemonic;
    }

    public Code getCode() {
        return this.code;
    }

    public void setCode(Code code) {
        this.code = code;
    }

    public String getTreeChildVisible() {
        return this.treeChildVisible;
    }

    public void setTreeChildVisible(String treeChildVisible) throws IllegalArgumentException {
        if (!zeus_TreeChildVisibleInitialized) {
            zeus_validTreeChildVisible = new Vector();
            zeus_validTreeChildVisible.addElement("true");
            zeus_validTreeChildVisible.addElement("false");
            zeus_TreeChildVisibleInitialized = true;
        }
        if (!zeus_validTreeChildVisible.contains(treeChildVisible)) {
            throw new IllegalArgumentException("Illegal value for attribute 'treeChildVisible'");
        }
        this.treeChildVisible = treeChildVisible;
        this.zeus_TreeChildVisibleSet = true;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this.zeus_LabelSet = true;
    }

    public String getTypeChildVisible() {
        return this.typeChildVisible;
    }

    public void setTypeChildVisible(String typeChildVisible) throws IllegalArgumentException {
        if (!zeus_TypeChildVisibleInitialized) {
            zeus_validTypeChildVisible = new Vector();
            zeus_validTypeChildVisible.addElement("true");
            zeus_validTypeChildVisible.addElement("false");
            zeus_TypeChildVisibleInitialized = true;
        }
        if (!zeus_validTypeChildVisible.contains(typeChildVisible)) {
            throw new IllegalArgumentException("Illegal value for attribute 'typeChildVisible'");
        }
        this.typeChildVisible = typeChildVisible;
        this.zeus_TypeChildVisibleSet = true;
    }

    public void setDocType(String name, String publicID, String systemID) {
        try {
            this.startDTD(name, publicID, systemID);
        }
        catch (SAXException neverHappens) {
            // empty catch block
        }
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void marshal(File file) throws IOException {
        this.marshal(new FileWriter(file));
    }

    public void marshal(OutputStream outputStream) throws IOException {
        this.marshal(new OutputStreamWriter(outputStream));
    }

    public void marshal(Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\" ");
        if (this.outputEncoding != null) {
            writer.write("encoding=\"");
            writer.write(this.outputEncoding);
            writer.write("\"?>\n\n");
        } else {
            writer.write("encoding=\"UTF-8\"?>\n\n");
        }
        writer.write(this.docTypeString);
        writer.write("\n");
        this.writeXMLRepresentation(writer, "");
        writer.flush();
        writer.close();
    }

    protected void writeXMLRepresentation(Writer writer, String indent) throws IOException {
        writer.write(indent);
        writer.write("<item");
        Iterator i = this.namespaceMappings.keySet().iterator();
        while (i.hasNext()) {
            String prefix = (String)i.next();
            String uri = (String)this.namespaceMappings.get(prefix);
            writer.write(" xmlns");
            if (!prefix.trim().equals("")) {
                writer.write(":");
                writer.write(prefix);
            }
            writer.write("=\"");
            writer.write(uri);
            writer.write("\"\n        ");
        }
        if (this.zeus_TreeChildVisibleSet) {
            writer.write(" tree-child-visible=\"");
            writer.write(this.escapeAttributeValue(this.treeChildVisible));
            writer.write("\"");
        }
        if (this.zeus_LabelSet) {
            writer.write(" label=\"");
            writer.write(this.escapeAttributeValue(this.label));
            writer.write("\"");
        }
        if (this.zeus_TypeChildVisibleSet) {
            writer.write(" type-child-visible=\"");
            writer.write(this.escapeAttributeValue(this.typeChildVisible));
            writer.write("\"");
        }
        writer.write(">");
        writer.write("\n");
        if (this.icon != null) {
            ((IconImpl)this.icon).writeXMLRepresentation(writer, indent + "  ");
        }
        if (this.accelerator != null) {
            ((AcceleratorImpl)this.accelerator).writeXMLRepresentation(writer, indent + "  ");
        }
        if (this.mnemonic != null) {
            ((MnemonicImpl)this.mnemonic).writeXMLRepresentation(writer, indent + "  ");
        }
        if (this.code != null) {
            ((CodeImpl)this.code).writeXMLRepresentation(writer, indent + "  ");
        }
        writer.write(indent);
        writer.write("</item>\n");
    }

    private String escapeAttributeValue(String attributeValue) {
        String returnValue = attributeValue;
        for (int i = 0; i < returnValue.length(); ++i) {
            char ch = returnValue.charAt(i);
            if (ch != '\"') continue;
            returnValue = returnValue.substring(0, i) + "&quot;" + returnValue.substring(i + 1);
        }
        return returnValue;
    }

    private String escapeTextValue(String textValue) {
        String returnValue = textValue;
        for (int i = 0; i < returnValue.length(); ++i) {
            char ch = returnValue.charAt(i);
            if (ch == '<') {
                returnValue = returnValue.substring(0, i) + "&lt;" + returnValue.substring(i + 1);
                continue;
            }
            if (ch != '>') continue;
            returnValue = returnValue.substring(0, i) + "&gt;" + returnValue.substring(i + 1);
        }
        return returnValue;
    }

    public static void setEntityResolver(EntityResolver resolver) {
        entityResolver = resolver;
    }

    public static void setErrorHandler(ErrorHandler handler) {
        errorHandler = handler;
    }

    public static Item unmarshal(File file) throws IOException {
        return ItemImpl.unmarshal(new FileReader(file));
    }

    public static Item unmarshal(File file, boolean validate) throws IOException {
        return ItemImpl.unmarshal(new FileReader(file), validate);
    }

    public static Item unmarshal(InputStream inputStream) throws IOException {
        return ItemImpl.unmarshal(new InputStreamReader(inputStream));
    }

    public static Item unmarshal(InputStream inputStream, boolean validate) throws IOException {
        return ItemImpl.unmarshal(new InputStreamReader(inputStream), validate);
    }

    public static Item unmarshal(Reader reader) throws IOException {
        return ItemImpl.unmarshal(reader, false);
    }

    public static Item unmarshal(Reader reader, boolean validate) throws IOException {
        ItemImpl item = ItemImpl.newInstance();
        item.setValidating(validate);
        item.setCurrentUNode(item);
        item.setParentUNode(null);
        XMLReader parser = null;
        String parserClass = System.getProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
        try {
            parser = XMLReaderFactory.createXMLReader(parserClass);
            if (entityResolver != null) {
                parser.setEntityResolver(entityResolver);
            }
            parser.setErrorHandler(item);
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", item);
            parser.setContentHandler(item);
        }
        catch (SAXException e) {
            throw new IOException("Could not load XML parser: " + e.getMessage());
        }
        InputSource inputSource = new InputSource(reader);
        try {
            parser.setFeature("http://xml.org/sax/features/validation", new Boolean(validate));
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            parser.parse(inputSource);
        }
        catch (SAXException e) {
            throw new IOException("Error parsing XML document: " + e.getMessage());
        }
        return item;
    }

    public Unmarshallable getParentUNode() {
        return this.zeus_parentUNode;
    }

    public void setParentUNode(Unmarshallable parentUNode) {
        this.zeus_parentUNode = parentUNode;
    }

    public Unmarshallable getCurrentUNode() {
        return this.zeus_currentUNode;
    }

    public void setCurrentUNode(Unmarshallable currentUNode) {
        this.zeus_currentUNode = currentUNode;
    }

    public void setValidating(boolean validate) {
        this.validate = validate;
    }

    public void startDocument() throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaceMappings.put(prefix, uri);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Unmarshallable current = this.getCurrentUNode();
        if (current != this) {
            current.startElement(namespaceURI, localName, qName, atts);
            return;
        }
        if (localName.equals("item") && !this.zeus_thisNodeHandled) {
            int len = atts.getLength();
            for (int i = 0; i < len; ++i) {
                String attName = atts.getLocalName(i);
                String attValue = atts.getValue(i);
                if (attName.equals("tree-child-visible")) {
                    this.setTreeChildVisible(attValue);
                }
                if (attName.equals("label")) {
                    this.setLabel(attValue);
                }
                if (!attName.equals("type-child-visible")) continue;
                this.setTypeChildVisible(attValue);
            }
            this.zeus_thisNodeHandled = true;
            return;
        }
        if (localName.equals("icon") && this.icon == null) {
            IconImpl icon = IconImpl.newInstance();
            current = this.getCurrentUNode();
            icon.setParentUNode(current);
            icon.setCurrentUNode(icon);
            this.setCurrentUNode(icon);
            icon.startElement(namespaceURI, localName, qName, atts);
            this.icon = icon;
            return;
        }
        if (localName.equals("accelerator") && this.accelerator == null) {
            AcceleratorImpl accelerator = AcceleratorImpl.newInstance();
            current = this.getCurrentUNode();
            accelerator.setParentUNode(current);
            accelerator.setCurrentUNode(accelerator);
            this.setCurrentUNode(accelerator);
            accelerator.startElement(namespaceURI, localName, qName, atts);
            this.accelerator = accelerator;
            return;
        }
        if (localName.equals("mnemonic") && this.mnemonic == null) {
            MnemonicImpl mnemonic = MnemonicImpl.newInstance();
            current = this.getCurrentUNode();
            mnemonic.setParentUNode(current);
            mnemonic.setCurrentUNode(mnemonic);
            this.setCurrentUNode(mnemonic);
            mnemonic.startElement(namespaceURI, localName, qName, atts);
            this.mnemonic = mnemonic;
            return;
        }
        if (localName.equals("code") && this.code == null) {
            CodeImpl code = CodeImpl.newInstance();
            current = this.getCurrentUNode();
            code.setParentUNode(current);
            code.setCurrentUNode(code);
            this.setCurrentUNode(code);
            code.startElement(namespaceURI, localName, qName, atts);
            this.code = code;
            return;
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        Unmarshallable current = this.getCurrentUNode();
        if (current != this) {
            current.endElement(namespaceURI, localName, qName);
            return;
        }
        Unmarshallable parent = this.getCurrentUNode().getParentUNode();
        if (parent != null) {
            parent.setCurrentUNode(parent);
        }
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        Unmarshallable current = this.getCurrentUNode();
        if (current != this) {
            current.characters(ch, start, len);
            return;
        }
        String text = new String(ch, start, len);
        text = text.trim();
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
    }

    public void warning(SAXParseException e) throws SAXException {
        if (errorHandler != null) {
            errorHandler.warning(e);
        }
    }

    public void error(SAXParseException e) throws SAXException {
        if (this.validate && !this.hasDTD) {
            throw new SAXException("Validation is turned on, but no DTD has been specified in the input XML document. Please supply a DTD through a DOCTYPE reference.");
        }
        if (errorHandler != null) {
            errorHandler.error(e);
        }
    }

    public void fatalError(SAXParseException e) throws SAXException {
        if (this.validate && !this.hasDTD) {
            throw new SAXException("Validation is turned on, but no DTD has been specified in the input XML document. Please supply a DTD through a DOCTYPE reference.");
        }
        if (errorHandler != null) {
            errorHandler.fatalError(e);
        }
    }

    public void startDTD(String name, String publicID, String systemID) throws SAXException {
        if (name == null || name.equals("")) {
            this.docTypeString = "";
            return;
        }
        this.hasDTD = true;
        StringBuffer docTypeSB = new StringBuffer();
        boolean hasPublic = false;
        docTypeSB.append("<!DOCTYPE ").append(name);
        if (publicID != null && !publicID.equals("")) {
            docTypeSB.append(" PUBLIC \"").append(publicID).append("\"");
            hasPublic = true;
        }
        if (systemID != null && !systemID.equals("")) {
            if (!hasPublic) {
                docTypeSB.append(" SYSTEM");
            }
            docTypeSB.append(" \"").append(systemID).append("\"");
        }
        docTypeSB.append(">");
        this.docTypeString = docTypeSB.toString();
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    static {
        prototype = null;
    }
}

