/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.explorerConfig;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.objectweb.util.explorer.explorerConfig.Code;
import org.objectweb.util.explorer.explorerConfig.CodeImpl;
import org.objectweb.util.explorer.explorerConfig.Panel;
import org.objectweb.util.explorer.explorerConfig.Table;
import org.objectweb.util.explorer.explorerConfig.TableImpl;
import org.objectweb.util.explorer.explorerConfig.Unmarshallable;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class PanelImpl
extends DefaultHandler
implements Cloneable,
Unmarshallable,
LexicalHandler,
Panel {
    private Code code;
    private List panelList = new LinkedList();
    private List tableList = new LinkedList();
    private String inheritTypePanel = "false";
    private static boolean zeus_InheritTypePanelInitialized;
    private static Vector zeus_validInheritTypePanel;
    private boolean zeus_InheritTypePanelSet;
    private String docTypeString;
    private String outputEncoding;
    private Unmarshallable zeus_currentUNode;
    private Unmarshallable zeus_parentUNode;
    private boolean zeus_thisNodeHandled = false;
    private boolean hasDTD;
    private boolean validate;
    private Map namespaceMappings;
    private static EntityResolver entityResolver;
    private static ErrorHandler errorHandler;
    private static PanelImpl prototype;

    public static void setPrototype(PanelImpl prototype) {
        PanelImpl.prototype = prototype;
    }

    public static PanelImpl newInstance() {
        try {
            return prototype != null ? (PanelImpl)prototype.clone() : new PanelImpl();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public PanelImpl() {
        zeus_InheritTypePanelInitialized = false;
        zeus_validInheritTypePanel = null;
        this.zeus_InheritTypePanelSet = false;
        this.docTypeString = "";
        this.hasDTD = false;
        this.validate = false;
        this.namespaceMappings = new HashMap();
    }

    public Code getCode() {
        return this.code;
    }

    public void setCode(Code code) {
        this.code = code;
    }

    public List getPanelList() {
        return this.panelList;
    }

    public void setPanelList(List panelList) {
        this.panelList = panelList;
    }

    public void addPanel(Panel panel) {
        this.panelList.add(panel);
    }

    public void removePanel(Panel panel) {
        this.panelList.remove(panel);
    }

    public List getTableList() {
        return this.tableList;
    }

    public void setTableList(List tableList) {
        this.tableList = tableList;
    }

    public void addTable(Table table) {
        this.tableList.add(table);
    }

    public void removeTable(Table table) {
        this.tableList.remove(table);
    }

    public String getInheritTypePanel() {
        return this.inheritTypePanel;
    }

    public void setInheritTypePanel(String inheritTypePanel) throws IllegalArgumentException {
        if (!zeus_InheritTypePanelInitialized) {
            zeus_validInheritTypePanel = new Vector();
            zeus_validInheritTypePanel.addElement("true");
            zeus_validInheritTypePanel.addElement("false");
            zeus_InheritTypePanelInitialized = true;
        }
        if (!zeus_validInheritTypePanel.contains(inheritTypePanel)) {
            throw new IllegalArgumentException("Illegal value for attribute 'inheritTypePanel'");
        }
        this.inheritTypePanel = inheritTypePanel;
        this.zeus_InheritTypePanelSet = true;
    }

    public void setDocType(String name, String publicID, String systemID) {
        try {
            this.startDTD(name, publicID, systemID);
        }
        catch (SAXException neverHappens) {
            // empty catch block
        }
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void marshal(File file) throws IOException {
        this.marshal(new FileWriter(file));
    }

    public void marshal(OutputStream outputStream) throws IOException {
        this.marshal(new OutputStreamWriter(outputStream));
    }

    public void marshal(Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\" ");
        if (this.outputEncoding != null) {
            writer.write("encoding=\"");
            writer.write(this.outputEncoding);
            writer.write("\"?>\n\n");
        } else {
            writer.write("encoding=\"UTF-8\"?>\n\n");
        }
        writer.write(this.docTypeString);
        writer.write("\n");
        this.writeXMLRepresentation(writer, "");
        writer.flush();
        writer.close();
    }

    protected void writeXMLRepresentation(Writer writer, String indent) throws IOException {
        writer.write(indent);
        writer.write("<panel");
        Iterator<Object> i = this.namespaceMappings.keySet().iterator();
        while (i.hasNext()) {
            String prefix = (String)i.next();
            String uri = (String)this.namespaceMappings.get(prefix);
            writer.write(" xmlns");
            if (!prefix.trim().equals("")) {
                writer.write(":");
                writer.write(prefix);
            }
            writer.write("=\"");
            writer.write(uri);
            writer.write("\"\n        ");
        }
        if (this.zeus_InheritTypePanelSet) {
            writer.write(" inherit-type-panel=\"");
            writer.write(this.escapeAttributeValue(this.inheritTypePanel));
            writer.write("\"");
        }
        writer.write(">");
        writer.write("\n");
        if (this.code != null) {
            ((CodeImpl)this.code).writeXMLRepresentation(writer, indent + "  ");
        }
        i = this.panelList.iterator();
        while (i.hasNext()) {
            PanelImpl panel = (PanelImpl)i.next();
            panel.writeXMLRepresentation(writer, indent + "  ");
        }
        i = this.tableList.iterator();
        while (i.hasNext()) {
            TableImpl table = (TableImpl)i.next();
            table.writeXMLRepresentation(writer, indent + "  ");
        }
        writer.write(indent);
        writer.write("</panel>\n");
    }

    private String escapeAttributeValue(String attributeValue) {
        String returnValue = attributeValue;
        for (int i = 0; i < returnValue.length(); ++i) {
            char ch = returnValue.charAt(i);
            if (ch != '\"') continue;
            returnValue = returnValue.substring(0, i) + "&quot;" + returnValue.substring(i + 1);
        }
        return returnValue;
    }

    private String escapeTextValue(String textValue) {
        String returnValue = textValue;
        for (int i = 0; i < returnValue.length(); ++i) {
            char ch = returnValue.charAt(i);
            if (ch == '<') {
                returnValue = returnValue.substring(0, i) + "&lt;" + returnValue.substring(i + 1);
                continue;
            }
            if (ch != '>') continue;
            returnValue = returnValue.substring(0, i) + "&gt;" + returnValue.substring(i + 1);
        }
        return returnValue;
    }

    public static void setEntityResolver(EntityResolver resolver) {
        entityResolver = resolver;
    }

    public static void setErrorHandler(ErrorHandler handler) {
        errorHandler = handler;
    }

    public static Panel unmarshal(File file) throws IOException {
        return PanelImpl.unmarshal(new FileReader(file));
    }

    public static Panel unmarshal(File file, boolean validate) throws IOException {
        return PanelImpl.unmarshal(new FileReader(file), validate);
    }

    public static Panel unmarshal(InputStream inputStream) throws IOException {
        return PanelImpl.unmarshal(new InputStreamReader(inputStream));
    }

    public static Panel unmarshal(InputStream inputStream, boolean validate) throws IOException {
        return PanelImpl.unmarshal(new InputStreamReader(inputStream), validate);
    }

    public static Panel unmarshal(Reader reader) throws IOException {
        return PanelImpl.unmarshal(reader, false);
    }

    public static Panel unmarshal(Reader reader, boolean validate) throws IOException {
        PanelImpl panel = PanelImpl.newInstance();
        panel.setValidating(validate);
        panel.setCurrentUNode(panel);
        panel.setParentUNode(null);
        XMLReader parser = null;
        String parserClass = System.getProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
        try {
            parser = XMLReaderFactory.createXMLReader(parserClass);
            if (entityResolver != null) {
                parser.setEntityResolver(entityResolver);
            }
            parser.setErrorHandler(panel);
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", panel);
            parser.setContentHandler(panel);
        }
        catch (SAXException e) {
            throw new IOException("Could not load XML parser: " + e.getMessage());
        }
        InputSource inputSource = new InputSource(reader);
        try {
            parser.setFeature("http://xml.org/sax/features/validation", new Boolean(validate));
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            parser.parse(inputSource);
        }
        catch (SAXException e) {
            throw new IOException("Error parsing XML document: " + e.getMessage());
        }
        return panel;
    }

    public Unmarshallable getParentUNode() {
        return this.zeus_parentUNode;
    }

    public void setParentUNode(Unmarshallable parentUNode) {
        this.zeus_parentUNode = parentUNode;
    }

    public Unmarshallable getCurrentUNode() {
        return this.zeus_currentUNode;
    }

    public void setCurrentUNode(Unmarshallable currentUNode) {
        this.zeus_currentUNode = currentUNode;
    }

    public void setValidating(boolean validate) {
        this.validate = validate;
    }

    public void startDocument() throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaceMappings.put(prefix, uri);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Unmarshallable current = this.getCurrentUNode();
        if (current != this) {
            current.startElement(namespaceURI, localName, qName, atts);
            return;
        }
        if (localName.equals("panel") && !this.zeus_thisNodeHandled) {
            int len = atts.getLength();
            for (int i = 0; i < len; ++i) {
                String attName = atts.getLocalName(i);
                String attValue = atts.getValue(i);
                if (!attName.equals("inherit-type-panel")) continue;
                this.setInheritTypePanel(attValue);
            }
            this.zeus_thisNodeHandled = true;
            return;
        }
        if (localName.equals("code") && this.code == null) {
            CodeImpl code = CodeImpl.newInstance();
            current = this.getCurrentUNode();
            code.setParentUNode(current);
            code.setCurrentUNode(code);
            this.setCurrentUNode(code);
            code.startElement(namespaceURI, localName, qName, atts);
            this.code = code;
            return;
        }
        if (localName.equals("panel")) {
            PanelImpl panel = PanelImpl.newInstance();
            current = this.getCurrentUNode();
            panel.setParentUNode(current);
            panel.setCurrentUNode(panel);
            this.setCurrentUNode(panel);
            panel.startElement(namespaceURI, localName, qName, atts);
            this.panelList.add(panel);
            return;
        }
        if (localName.equals("table")) {
            TableImpl table = TableImpl.newInstance();
            current = this.getCurrentUNode();
            table.setParentUNode(current);
            table.setCurrentUNode(table);
            this.setCurrentUNode(table);
            table.startElement(namespaceURI, localName, qName, atts);
            this.tableList.add(table);
            return;
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        Unmarshallable current = this.getCurrentUNode();
        if (current != this) {
            current.endElement(namespaceURI, localName, qName);
            return;
        }
        Unmarshallable parent = this.getCurrentUNode().getParentUNode();
        if (parent != null) {
            parent.setCurrentUNode(parent);
        }
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        Unmarshallable current = this.getCurrentUNode();
        if (current != this) {
            current.characters(ch, start, len);
            return;
        }
        String text = new String(ch, start, len);
        text = text.trim();
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
    }

    public void warning(SAXParseException e) throws SAXException {
        if (errorHandler != null) {
            errorHandler.warning(e);
        }
    }

    public void error(SAXParseException e) throws SAXException {
        if (this.validate && !this.hasDTD) {
            throw new SAXException("Validation is turned on, but no DTD has been specified in the input XML document. Please supply a DTD through a DOCTYPE reference.");
        }
        if (errorHandler != null) {
            errorHandler.error(e);
        }
    }

    public void fatalError(SAXParseException e) throws SAXException {
        if (this.validate && !this.hasDTD) {
            throw new SAXException("Validation is turned on, but no DTD has been specified in the input XML document. Please supply a DTD through a DOCTYPE reference.");
        }
        if (errorHandler != null) {
            errorHandler.fatalError(e);
        }
    }

    public void startDTD(String name, String publicID, String systemID) throws SAXException {
        if (name == null || name.equals("")) {
            this.docTypeString = "";
            return;
        }
        this.hasDTD = true;
        StringBuffer docTypeSB = new StringBuffer();
        boolean hasPublic = false;
        docTypeSB.append("<!DOCTYPE ").append(name);
        if (publicID != null && !publicID.equals("")) {
            docTypeSB.append(" PUBLIC \"").append(publicID).append("\"");
            hasPublic = true;
        }
        if (systemID != null && !systemID.equals("")) {
            if (!hasPublic) {
                docTypeSB.append(" SYSTEM");
            }
            docTypeSB.append(" \"").append(systemID).append("\"");
        }
        docTypeSB.append(">");
        this.docTypeString = docTypeSB.toString();
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    static {
        prototype = null;
    }
}

