/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.explorerConfig.beans;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.objectweb.apollon.framework.Bean;
import org.objectweb.apollon.framework.ExtensionManager;
import org.objectweb.apollon.framework.IndexTable;
import org.objectweb.apollon.framework.Listener;
import org.objectweb.apollon.framework.ModificationEvent;
import org.objectweb.util.explorer.explorerConfig.Item;
import org.objectweb.util.explorer.explorerConfig.MenuImpl;
import org.objectweb.util.explorer.explorerConfig.Mnemonic;
import org.objectweb.util.explorer.explorerConfig.Separator;
import org.objectweb.util.explorer.explorerConfig.Unmarshallable;
import org.objectweb.util.explorer.explorerConfig.beans.ItemBeanImpl;
import org.objectweb.util.explorer.explorerConfig.beans.MenuBean;
import org.objectweb.util.explorer.explorerConfig.beans.MenuExtensionManager;
import org.objectweb.util.explorer.explorerConfig.beans.MenuListener;
import org.objectweb.util.explorer.explorerConfig.beans.MenuModificationEvent;
import org.objectweb.util.explorer.explorerConfig.beans.MnemonicBeanImpl;
import org.objectweb.util.explorer.explorerConfig.beans.SeparatorBeanImpl;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class MenuBeanImpl
extends MenuImpl
implements MenuBean {
    private List orderedList = new ArrayList();
    private ArrayList menuListeners = new ArrayList();
    private ExtensionManager _extManager = new MenuExtensionManager(this);
    private Unmarshallable zeus_currentUNode;
    private Unmarshallable zeus_parentUNode;
    private boolean zeus_thisNodeHandled = false;
    private boolean hasDTD;
    private boolean validate;
    private Map namespaceMappings;
    private static EntityResolver entityResolver;
    private static ErrorHandler errorHandler;

    public synchronized void addMenuListener(Listener l) {
        this.menuListeners.add(l);
    }

    public synchronized void removeMenuListener(MenuListener l) {
        this.menuListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners() {
        MenuModificationEvent modifEvent = new MenuModificationEvent(this);
        ArrayList lv = null;
        MenuBeanImpl menuBeanImpl = this;
        synchronized (menuBeanImpl) {
            lv = (ArrayList)this.menuListeners.clone();
        }
        for (int i = 0; i < lv.size(); ++i) {
            ((Listener)lv.get(i)).refreshData((ModificationEvent)modifEvent);
        }
    }

    public ExtensionManager getExtensionManager() {
        return this._extManager;
    }

    public List getChildrenList() {
        LinkedList<Bean> result = new LinkedList<Bean>();
        Iterator i = this.orderedList.iterator();
        while (i.hasNext()) {
            Object child = i.next();
            if (child instanceof String) {
                if (IndexTable.lookup((String)((String)child)) == null) continue;
                result.add(IndexTable.lookup((String)((String)child)));
                continue;
            }
            result.add((Bean)child);
        }
        return result;
    }

    public void setMnemonic(Mnemonic mnemonic) throws IllegalArgumentException {
        this.orderedList.remove(this.getMnemonic());
        if (mnemonic != null) {
            this.orderedList.add(mnemonic);
        }
        super.setMnemonic(mnemonic);
    }

    public void setItemList(List itemList) throws IllegalArgumentException {
        super.setItemList(itemList);
    }

    public void addItem(Item item) {
        super.addItem(item);
        this.orderedList.add(item);
        this.notifyListeners();
    }

    public void removeItem(Item item) {
        super.removeItem(item);
        this.orderedList.remove(item);
        this.notifyListeners();
    }

    public void setSeparatorList(List separatorList) throws IllegalArgumentException {
        super.setSeparatorList(separatorList);
    }

    public void addSeparator(Separator separator) {
        super.addSeparator(separator);
        this.orderedList.add(separator);
        this.notifyListeners();
    }

    public void removeSeparator(Separator separator) {
        super.removeSeparator(separator);
        this.orderedList.remove(separator);
        this.notifyListeners();
    }

    public void setLabel(String label) throws IllegalArgumentException {
        super.setLabel(label);
    }

    public void setInheritTypeMenu(String inheritTypeMenu) throws IllegalArgumentException {
        super.setInheritTypeMenu(inheritTypeMenu);
    }

    public void setInheritTreeMenu(String inheritTreeMenu) throws IllegalArgumentException {
        super.setInheritTreeMenu(inheritTreeMenu);
    }

    public static void setEntityResolver(EntityResolver resolver) {
        entityResolver = resolver;
    }

    public void marshalBean(File file) throws IOException {
        this.marshal(file);
    }

    public static MenuBean unmarshalBean(File file) throws IOException {
        return MenuBeanImpl.unmarshalBean(new FileReader(file), false);
    }

    public static MenuBean unmarshalBean(Reader reader, boolean validate) throws IOException {
        MenuBeanImpl menu = new MenuBeanImpl();
        menu.setValidating(validate);
        menu.setCurrentUNode(menu);
        menu.setParentUNode(null);
        XMLReader parser = null;
        String parserClass = System.getProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
        try {
            parser = XMLReaderFactory.createXMLReader(parserClass);
            if (entityResolver != null) {
                parser.setEntityResolver(entityResolver);
            }
            parser.setErrorHandler(menu);
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", menu);
            parser.setContentHandler(menu);
        }
        catch (SAXException e) {
            throw new IOException("Could not load XML parser: " + e.getMessage());
        }
        InputSource inputSource = new InputSource(reader);
        try {
            parser.setFeature("http://xml.org/sax/features/validation", new Boolean(validate));
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            parser.parse(inputSource);
        }
        catch (SAXException e) {
            throw new IOException("Error parsing XML document: " + e.getMessage());
        }
        return menu;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Unmarshallable current = this.getCurrentUNode();
        if (current != this) {
            current.startElement(namespaceURI, localName, qName, atts);
            return;
        }
        if (localName.equals("menu") && !this.zeus_thisNodeHandled) {
            int len = atts.getLength();
            for (int i = 0; i < len; ++i) {
                String attName = atts.getLocalName(i);
                String attValue = atts.getValue(i);
                if (attName.equals("label")) {
                    this.setLabel(attValue);
                }
                if (attName.equals("inherit-type-menu")) {
                    this.setInheritTypeMenu(attValue);
                }
                if (!attName.equals("inherit-tree-menu")) continue;
                this.setInheritTreeMenu(attValue);
            }
            this.zeus_thisNodeHandled = true;
            return;
        }
        if (localName.equals("mnemonic")) {
            MnemonicBeanImpl mnemonic = new MnemonicBeanImpl();
            current = this.getCurrentUNode();
            mnemonic.setParentUNode(current);
            mnemonic.setCurrentUNode(mnemonic);
            this.setCurrentUNode(mnemonic);
            mnemonic.startElement(namespaceURI, localName, qName, atts);
            this.setMnemonic(mnemonic);
            return;
        }
        if (localName.equals("item")) {
            ItemBeanImpl item = new ItemBeanImpl();
            current = this.getCurrentUNode();
            item.setParentUNode(current);
            item.setCurrentUNode(item);
            this.setCurrentUNode(item);
            item.startElement(namespaceURI, localName, qName, atts);
            this.getItemList().add(item);
            this.orderedList.add(item);
            return;
        }
        if (localName.equals("separator")) {
            SeparatorBeanImpl separator = new SeparatorBeanImpl();
            current = this.getCurrentUNode();
            separator.setParentUNode(current);
            separator.setCurrentUNode(separator);
            this.setCurrentUNode(separator);
            separator.startElement(namespaceURI, localName, qName, atts);
            this.getSeparatorList().add(separator);
            this.orderedList.add(separator);
            return;
        }
    }

    public String idBean() {
        return "[Menu]";
    }
}

