/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.explorerConfig.beans;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.objectweb.apollon.framework.Bean;
import org.objectweb.apollon.framework.ExtensionManager;
import org.objectweb.apollon.framework.IndexTable;
import org.objectweb.apollon.framework.Listener;
import org.objectweb.apollon.framework.ModificationEvent;
import org.objectweb.util.explorer.explorerConfig.Code;
import org.objectweb.util.explorer.explorerConfig.Panel;
import org.objectweb.util.explorer.explorerConfig.PanelImpl;
import org.objectweb.util.explorer.explorerConfig.Table;
import org.objectweb.util.explorer.explorerConfig.Unmarshallable;
import org.objectweb.util.explorer.explorerConfig.beans.CodeBeanImpl;
import org.objectweb.util.explorer.explorerConfig.beans.PanelBean;
import org.objectweb.util.explorer.explorerConfig.beans.PanelExtensionManager;
import org.objectweb.util.explorer.explorerConfig.beans.PanelListener;
import org.objectweb.util.explorer.explorerConfig.beans.PanelModificationEvent;
import org.objectweb.util.explorer.explorerConfig.beans.TableBeanImpl;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class PanelBeanImpl
extends PanelImpl
implements PanelBean {
    private List orderedList = new ArrayList();
    private ArrayList panelListeners = new ArrayList();
    private ExtensionManager _extManager = new PanelExtensionManager(this);
    private Unmarshallable zeus_currentUNode;
    private Unmarshallable zeus_parentUNode;
    private boolean zeus_thisNodeHandled = false;
    private boolean hasDTD;
    private boolean validate;
    private Map namespaceMappings;
    private static EntityResolver entityResolver;
    private static ErrorHandler errorHandler;

    public synchronized void addPanelListener(Listener l) {
        this.panelListeners.add(l);
    }

    public synchronized void removePanelListener(PanelListener l) {
        this.panelListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners() {
        PanelModificationEvent modifEvent = new PanelModificationEvent(this);
        ArrayList lv = null;
        PanelBeanImpl panelBeanImpl = this;
        synchronized (panelBeanImpl) {
            lv = (ArrayList)this.panelListeners.clone();
        }
        for (int i = 0; i < lv.size(); ++i) {
            ((Listener)lv.get(i)).refreshData((ModificationEvent)modifEvent);
        }
    }

    public ExtensionManager getExtensionManager() {
        return this._extManager;
    }

    public List getChildrenList() {
        LinkedList<Bean> result = new LinkedList<Bean>();
        Iterator i = this.orderedList.iterator();
        while (i.hasNext()) {
            Object child = i.next();
            if (child instanceof String) {
                if (IndexTable.lookup((String)((String)child)) == null) continue;
                result.add(IndexTable.lookup((String)((String)child)));
                continue;
            }
            result.add((Bean)child);
        }
        return result;
    }

    public void setCode(Code code) throws IllegalArgumentException {
        this.orderedList.remove(this.getCode());
        if (code != null) {
            this.orderedList.add(code);
        }
        super.setCode(code);
    }

    public void setPanelList(List panelList) throws IllegalArgumentException {
        super.setPanelList(panelList);
    }

    public void addPanel(Panel panel) {
        super.addPanel(panel);
        this.orderedList.add(panel);
        this.notifyListeners();
    }

    public void removePanel(Panel panel) {
        super.removePanel(panel);
        this.orderedList.remove(panel);
        this.notifyListeners();
    }

    public void setTableList(List tableList) throws IllegalArgumentException {
        super.setTableList(tableList);
    }

    public void addTable(Table table) {
        super.addTable(table);
        this.orderedList.add(table);
        this.notifyListeners();
    }

    public void removeTable(Table table) {
        super.removeTable(table);
        this.orderedList.remove(table);
        this.notifyListeners();
    }

    public void setInheritTypePanel(String inheritTypePanel) throws IllegalArgumentException {
        super.setInheritTypePanel(inheritTypePanel);
    }

    public static void setEntityResolver(EntityResolver resolver) {
        entityResolver = resolver;
    }

    public void marshalBean(File file) throws IOException {
        this.marshal(file);
    }

    public static PanelBean unmarshalBean(File file) throws IOException {
        return PanelBeanImpl.unmarshalBean(new FileReader(file), false);
    }

    public static PanelBean unmarshalBean(Reader reader, boolean validate) throws IOException {
        PanelBeanImpl panel = new PanelBeanImpl();
        panel.setValidating(validate);
        panel.setCurrentUNode(panel);
        panel.setParentUNode(null);
        XMLReader parser = null;
        String parserClass = System.getProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
        try {
            parser = XMLReaderFactory.createXMLReader(parserClass);
            if (entityResolver != null) {
                parser.setEntityResolver(entityResolver);
            }
            parser.setErrorHandler(panel);
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", panel);
            parser.setContentHandler(panel);
        }
        catch (SAXException e) {
            throw new IOException("Could not load XML parser: " + e.getMessage());
        }
        InputSource inputSource = new InputSource(reader);
        try {
            parser.setFeature("http://xml.org/sax/features/validation", new Boolean(validate));
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            parser.parse(inputSource);
        }
        catch (SAXException e) {
            throw new IOException("Error parsing XML document: " + e.getMessage());
        }
        return panel;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Unmarshallable current = this.getCurrentUNode();
        if (current != this) {
            current.startElement(namespaceURI, localName, qName, atts);
            return;
        }
        if (localName.equals("panel") && !this.zeus_thisNodeHandled) {
            int len = atts.getLength();
            for (int i = 0; i < len; ++i) {
                String attName = atts.getLocalName(i);
                String attValue = atts.getValue(i);
                if (!attName.equals("inherit-type-panel")) continue;
                this.setInheritTypePanel(attValue);
            }
            this.zeus_thisNodeHandled = true;
            return;
        }
        if (localName.equals("code")) {
            CodeBeanImpl code = new CodeBeanImpl();
            current = this.getCurrentUNode();
            code.setParentUNode(current);
            code.setCurrentUNode(code);
            this.setCurrentUNode(code);
            code.startElement(namespaceURI, localName, qName, atts);
            this.setCode(code);
            return;
        }
        if (localName.equals("panel")) {
            PanelBeanImpl panel = new PanelBeanImpl();
            current = this.getCurrentUNode();
            panel.setParentUNode(current);
            panel.setCurrentUNode(panel);
            this.setCurrentUNode(panel);
            panel.startElement(namespaceURI, localName, qName, atts);
            this.getPanelList().add(panel);
            this.orderedList.add(panel);
            return;
        }
        if (localName.equals("table")) {
            TableBeanImpl table = new TableBeanImpl();
            current = this.getCurrentUNode();
            table.setParentUNode(current);
            table.setCurrentUNode(table);
            this.setCurrentUNode(table);
            table.startElement(namespaceURI, localName, qName, atts);
            this.getTableList().add(table);
            this.orderedList.add(table);
            return;
        }
    }

    public String idBean() {
        return "[Panel]";
    }
}

