/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.interpreter.lib.swing;

import java.net.URL;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.util.explorer.api.IconProvider;
import org.objectweb.util.explorer.api.MenuItem;
import org.objectweb.util.explorer.api.MenuItemTreeView;
import org.objectweb.util.explorer.api.TreeView;
import org.objectweb.util.explorer.core.code.api.Code;
import org.objectweb.util.explorer.core.common.api.Description;
import org.objectweb.util.explorer.core.icon.api.IconDescription;
import org.objectweb.util.explorer.core.menu.api.ItemDescription;
import org.objectweb.util.explorer.core.menu.api.MenuDescription;
import org.objectweb.util.explorer.core.menu.api.MenuElement;
import org.objectweb.util.explorer.core.menu.api.MenuSeparator;
import org.objectweb.util.explorer.interpreter.api.DescriptionInterpreter;
import org.objectweb.util.explorer.interpreter.lib.AbstractDescriptionInterpreter;
import org.objectweb.util.explorer.swing.icon.IconFileProvider;
import org.objectweb.util.explorer.swing.menu.GenericAction;

public class MenuInterpreter
extends AbstractDescriptionInterpreter {
    protected final String ICON_INTERPRETER = "icon-interpreter";
    static /* synthetic */ Class class$org$objectweb$util$explorer$api$MenuItem;

    protected Icon getIcon(IconDescription iconDesc, TreeView treeView) {
        IconProvider iconProvider;
        if (iconDesc != null && (iconProvider = (IconProvider)this.getIconInterpreter().interprete(iconDesc, treeView)) != null) {
            Object object = iconProvider.newIcon(treeView.getSelectedObject());
            if (object instanceof Icon) {
                return (Icon)object;
            }
            if (object instanceof String) {
                return (Icon)new IconFileProvider((String)object).newIcon(treeView.getSelectedObject());
            }
            if (object instanceof URL) {
                return (Icon)new IconFileProvider((URL)object).newIcon(treeView.getSelectedObject());
            }
        }
        return null;
    }

    protected Action getAction(ItemDescription itemDesc, MenuItemTreeView treeView) {
        if (itemDesc != null && !itemDesc.isEmpty()) {
            Code actionCode = this.getCodeProvider().getCode(itemDesc.getCodeDescription());
            if (actionCode != null && actionCode.isInstanceOf(class$org$objectweb$util$explorer$api$MenuItem == null ? (class$org$objectweb$util$explorer$api$MenuItem = MenuInterpreter.class$("org.objectweb.util.explorer.api.MenuItem")) : class$org$objectweb$util$explorer$api$MenuItem)) {
                MenuItem action = (MenuItem)actionCode.createInstance();
                int actionStatus = action.getStatus(treeView);
                Icon icon = this.getIcon(itemDesc.getIconDescription(), treeView);
                if (actionStatus != 3) {
                    return new GenericAction(itemDesc, action, treeView, icon, actionStatus == 1);
                }
            } else {
                this.getTrace().warn(itemDesc.getCodeDescription().getCode() + " is not a MenuItem instance!");
            }
        }
        return null;
    }

    protected JSeparator getSeparator(MenuSeparator menuSeparator) {
        return new JSeparator();
    }

    protected JPopupMenu createMenu(MenuDescription menuDesc, MenuItemTreeView treeView) {
        JPopupMenu menu = null;
        if (menuDesc != null && !menuDesc.isEmpty()) {
            menu = new JPopupMenu();
            MenuElement[] menuElement = menuDesc.getAllMenuElements();
            for (int i = 0; i < menuElement.length; ++i) {
                MenuElement element = menuElement[i];
                if (element instanceof ItemDescription) {
                    Action action = this.getAction((ItemDescription)element, treeView);
                    if (action == null) continue;
                    menu.add(action);
                    continue;
                }
                if (!(element instanceof MenuSeparator)) continue;
                menu.add(this.getSeparator((MenuSeparator)element));
            }
        }
        return menu;
    }

    protected DescriptionInterpreter getIconInterpreter() {
        try {
            return (DescriptionInterpreter)this.lookupFc("icon-interpreter");
        }
        catch (NoSuchInterfaceException e) {
            this.getTrace().warn("icon-interpreter: interface not found!");
            return null;
        }
    }

    public String[] clientFc() {
        return new String[]{"code-provider", "icon-interpreter"};
    }

    public Object interprete(Description description, Object params) {
        MenuDescription menuDesc = (MenuDescription)description;
        return this.createMenu(menuDesc, (MenuItemTreeView)params);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

