/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.parser.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.util.explorer.core.common.lib.ClassResolver;
import org.objectweb.util.explorer.core.common.lib.XMLFileFilter;
import org.objectweb.util.explorer.explorerConfig.beans.ExplorerBean;
import org.objectweb.util.explorer.explorerConfig.beans.ExplorerBeanImpl;
import org.objectweb.util.explorer.parser.api.ExplorerParser;
import org.objectweb.util.explorer.parser.lib.AbstractParser;

public class ExplorerParserLoader
extends AbstractParser
implements BindingController {
    protected ExplorerParser dispatcher_;

    protected InputStream getInputStream(String resource) {
        InputStream inputStream = ClassResolver.getResourceAsStream(resource);
        if (inputStream == null) {
            try {
                inputStream = new URL(resource).openStream();
            }
            catch (MalformedURLException e) {
                try {
                    inputStream = new FileInputStream(resource);
                }
                catch (FileNotFoundException e1) {
                    this.getTrace().info(resource + ": File not found on the file system!");
                    return null;
                }
            }
            catch (IOException e) {
                this.getTrace().info(resource + ": Failed to open stream on resource!");
                return null;
            }
        }
        return inputStream;
    }

    protected void parse(InputStream inputStream) {
        if (inputStream != null) {
            try {
                ExplorerBean explorer = ExplorerBeanImpl.unmarshalBean(new InputStreamReader(inputStream), false);
                if (explorer != null) {
                    this.dispatcher_.parseExplorer(explorer);
                }
            }
            catch (IOException e) {
                this.getTrace().info("Error during parsing!\n" + e.getMessage());
            }
        }
    }

    protected void parse(String resource) {
        File file = new File(resource);
        if (file.exists() && file.isDirectory()) {
            File[] files = file.listFiles(new XMLFileFilter());
            for (int i = 0; i < files.length; ++i) {
                this.parse(files[i].toString());
            }
        } else {
            this.parse(this.getInputStream(resource));
        }
    }

    public void bindFc(String itfName, Object itfValue) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (itfName.equals("explorer-parser")) {
            this.dispatcher_ = (ExplorerParser)itfValue;
        }
    }

    public Object lookupFc(String itfName) throws NoSuchInterfaceException {
        if (itfName.equals("explorer-parser")) {
            return this.dispatcher_;
        }
        return null;
    }

    public void unbindFc(String itfName) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (itfName.equals("explorer-parser")) {
            this.dispatcher_ = null;
        }
    }

    public String[] listFc() {
        return new String[]{"explorer-parser"};
    }

    public void parse() {
        for (int i = 0; i < this.urlFiles_.size(); ++i) {
            this.parse((String)this.urlFiles_.get(i));
        }
        this.urlFiles_.clear();
    }
}

