/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.parser.lib;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.objectweb.util.explorer.core.common.lib.BasicLoggable;
import org.objectweb.util.explorer.core.common.lib.ClassResolver;
import org.objectweb.util.explorer.explorerConfig.Jar;
import org.objectweb.util.explorer.explorerConfig.Node;
import org.objectweb.util.explorer.explorerConfig.beans.ExplorerBean;
import org.objectweb.util.explorer.parser.api.ExplorerParser;
import org.objectweb.util.explorer.parser.api.NodeParser;

public class JarManager
extends BasicLoggable
implements ExplorerParser,
NodeParser {
    protected void loadJars(List jarList) {
        Vector<URL> urlList = new Vector<URL>();
        Iterator it = jarList.iterator();
        while (it.hasNext()) {
            String jarUrl = ((Jar)it.next()).getUrl();
            try {
                urlList.add(new URL(jarUrl));
            }
            catch (MalformedURLException e) {
                this.getTrace().info(jarUrl + " : Malformed URL!");
            }
        }
        if (!urlList.isEmpty()) {
            ClassResolver.addContext(urlList.toArray(new URL[0]));
        }
    }

    public void parseExplorer(ExplorerBean explorer) {
        this.loadJars(explorer.getJarList());
    }

    public void parseNode(Object key, Node node) {
        this.loadJars(node.getJarList());
    }
}

