/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.parser.lib;

import java.util.Iterator;
import java.util.List;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.util.explorer.core.common.api.BadParamException;
import org.objectweb.util.explorer.core.common.api.KeyProvider;
import org.objectweb.util.explorer.core.common.lib.BindingFeature;
import org.objectweb.util.explorer.explorerConfig.Node;
import org.objectweb.util.explorer.explorerConfig.Role;
import org.objectweb.util.explorer.explorerConfig.beans.ExplorerBean;
import org.objectweb.util.explorer.parser.api.ExplorerParser;
import org.objectweb.util.explorer.parser.api.NodeParser;
import org.objectweb.util.explorer.parser.api.RoleParser;

public class NodeDispatcher
extends BindingFeature
implements ExplorerParser,
RoleParser {
    protected void dispatchNode(String roleId, Node theNode) {
        try {
            String[] keyElements = new String[]{theNode.getTypeSystem(), theNode.getTypeName(), roleId};
            Object key = ((KeyProvider)this.lookupFc("key-provider")).computeKey(keyElements);
            String[] clientIftNames = this.listFc();
            for (int i = 0; i < clientIftNames.length; ++i) {
                if (!clientIftNames[i].startsWith("node-parser")) continue;
                ((NodeParser)this.lookupFc(clientIftNames[i])).parseNode(key, theNode);
            }
        }
        catch (BadParamException e) {
            e.printStackTrace();
        }
        catch (NoSuchInterfaceException e) {
            e.printStackTrace();
        }
    }

    protected void parseNodeList(String roleId, List nodeList) {
        Iterator it = nodeList.iterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (node == null) continue;
            this.dispatchNode(roleId, node);
        }
    }

    public String[] clientFc() {
        return new String[]{"node-parser", "key-provider"};
    }

    public void parseExplorer(ExplorerBean explorer) {
        this.parseNodeList("_Default_Role_", explorer.getNodeList());
    }

    public void parseRole(Role role) {
        this.parseNodeList(role.getId(), role.getNodeList());
    }
}

