/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.parser.lib;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.util.explorer.core.common.lib.BindingFeature;
import org.objectweb.util.explorer.core.role.api.RoleDescription;
import org.objectweb.util.explorer.core.role.api.RoleFeeder;
import org.objectweb.util.explorer.core.role.lib.DefaultRoleDescription;
import org.objectweb.util.explorer.explorerConfig.Role;
import org.objectweb.util.explorer.explorerConfig.beans.ExplorerBean;
import org.objectweb.util.explorer.parser.api.ExplorerParser;
import org.objectweb.util.explorer.parser.api.RoleParser;

public class RoleManager
extends BindingFeature
implements ExplorerParser {
    protected boolean firstTime_ = true;

    protected void initRole() {
        if (this.firstTime_) {
            this.storeRole(this.createDefaultRoleDesc());
            this.firstTime_ = false;
        }
    }

    public void storeRole(RoleDescription roleDesc) {
        try {
            ((RoleFeeder)this.lookupFc("role-feeder")).feed(roleDesc);
        }
        catch (NoSuchInterfaceException e1) {
            e1.printStackTrace();
        }
    }

    protected RoleDescription createDefaultRoleDesc() {
        DefaultRoleDescription defaultRole = new DefaultRoleDescription();
        defaultRole.setId("_Default_Role_");
        defaultRole.setInheritance(new String[0]);
        defaultRole.setConcrete(false);
        return defaultRole;
    }

    protected RoleDescription createRoleDesc(Role role) {
        DefaultRoleDescription theRoleDef = new DefaultRoleDescription();
        Vector<String> v = new Vector<String>();
        if (role.getXmlextends() != null) {
            StringTokenizer st = new StringTokenizer(role.getXmlextends(), ",");
            while (st.hasMoreTokens()) {
                v.add(st.nextToken().trim());
            }
        }
        theRoleDef.setId(role.getId().trim());
        theRoleDef.setInheritance(v.toArray(new String[0]));
        theRoleDef.setConcrete(role.getKind().equals("concrete"));
        return theRoleDef;
    }

    public String[] clientFc() {
        return new String[]{"role-parser", "role-feeder"};
    }

    public void parseExplorer(ExplorerBean explorer) {
        this.initRole();
        List theRoles = explorer.getRoleList();
        Iterator it = theRoles.iterator();
        while (it.hasNext()) {
            Role theRole = (Role)it.next();
            RoleDescription roleDesc = this.createRoleDesc(theRole);
            this.storeRole(roleDesc);
            String[] clientIftNames = this.listFc();
            for (int i = 0; i < clientIftNames.length; ++i) {
                if (!clientIftNames[i].startsWith("role-parser")) continue;
                try {
                    ((RoleParser)this.lookupFc(clientIftNames[i])).parseRole(theRole);
                    continue;
                }
                catch (NoSuchInterfaceException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

