/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.parser.lib;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.objectweb.util.explorer.core.common.lib.BasicLoggable;
import org.objectweb.util.explorer.core.common.lib.ClassResolver;
import org.objectweb.util.explorer.explorerConfig.Zip;
import org.objectweb.util.explorer.explorerConfig.beans.ExplorerBean;
import org.objectweb.util.explorer.parser.api.ExplorerParser;

public class ZipManager
extends BasicLoggable
implements ExplorerParser {
    protected File extractedFolder_ = null;

    public ZipManager() {
        System.runFinalizersOnExit((boolean)true);
    }

    protected void remove(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                File[] children = file.listFiles();
                for (int i = 0; i < children.length; ++i) {
                    this.remove(children[i]);
                }
            }
            file.delete();
        }
    }

    protected void writeFile(InputStream input, OutputStream output) throws IOException {
        int bufferSize = 1024;
        byte[] buffer = new byte[bufferSize];
        int length = 0;
        while ((length = input.read(buffer)) > 0) {
            output.write(buffer, 0, length);
        }
        output.close();
        input.close();
    }

    protected void extractEntry(ZipFile file, ZipEntry entry, String fileName) throws IOException {
        this.writeFile(file.getInputStream(entry), new FileOutputStream(fileName));
    }

    protected void createDirectory(String path) {
        File directory = new File(path);
        if (!directory.exists()) {
            directory.deleteOnExit();
            directory.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractFile(File file, Vector javaArchives) throws IOException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file.toString());
        }
        catch (ZipException e) {
        }
        finally {
            file.deleteOnExit();
        }
        if (zipFile != null) {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (zipEntry.isDirectory()) {
                    this.createDirectory(this.extractedFolder_.getCanonicalPath() + "/" + zipEntry.getName());
                    continue;
                }
                int indice = zipEntry.getName().lastIndexOf(47);
                if (indice != -1) {
                    this.createDirectory(this.extractedFolder_.getCanonicalPath() + "/" + zipEntry.getName().substring(0, indice));
                }
                String fileName = this.extractedFolder_.getCanonicalPath() + "/" + zipEntry.getName();
                try {
                    this.extractEntry(zipFile, zipEntry, fileName);
                }
                catch (IOException e) {
                    this.getTrace().warn("IOException: " + e.getMessage());
                    e.printStackTrace();
                }
                if (zipEntry.getName().toLowerCase().endsWith(".jar")) {
                    File jarFile = new File(fileName);
                    jarFile.deleteOnExit();
                    try {
                        javaArchives.add(jarFile.toURL());
                    }
                    catch (IOException e) {
                        this.getTrace().warn("IOException: " + e.getMessage());
                        e.printStackTrace();
                    }
                    continue;
                }
                this.extractFile(new File(fileName), javaArchives);
            }
        }
    }

    protected void loadZip(URL zipURL) throws IOException {
        if (zipURL != null) {
            Vector javaArchives = new Vector();
            String fileName = this.extractedFolder_.getCanonicalPath() + "/temp.zip";
            this.writeFile(zipURL.openStream(), new FileOutputStream(fileName));
            File zipFile = new File(fileName);
            zipFile.deleteOnExit();
            this.extractFile(zipFile, javaArchives);
            ClassResolver.addContext(javaArchives.toArray(new URL[0]));
        }
    }

    protected void loadZips(List zipList) {
        if (zipList != null && zipList.size() > 0) {
            if (this.extractedFolder_ == null) {
                String tmpDir = System.getProperty("java.io.tmpdir");
                if (!tmpDir.endsWith("/") && !tmpDir.endsWith("\\")) {
                    tmpDir = tmpDir + "/";
                }
                this.extractedFolder_ = new File(tmpDir + "explorer" + System.currentTimeMillis());
                this.extractedFolder_.mkdir();
                this.extractedFolder_.deleteOnExit();
            }
            Iterator i = zipList.iterator();
            while (i.hasNext()) {
                Zip zip = (Zip)i.next();
                try {
                    this.loadZip(new URL(zip.getUrl()));
                }
                catch (MalformedURLException e) {
                    this.getTrace().warn("MalformedURLException: " + e.getMessage());
                }
                catch (IOException e) {
                    this.getTrace().warn("IOException: " + e.getMessage());
                }
            }
        }
    }

    public void parseExplorer(ExplorerBean explorer) {
        this.loadZips(explorer.getZipList());
    }

    public void finalize() throws Throwable {
        if (this.extractedFolder_ != null && this.extractedFolder_.exists()) {
            this.remove(this.extractedFolder_);
        }
    }
}

