/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.resolver.lib;

import org.objectweb.util.explorer.api.Entry;
import org.objectweb.util.explorer.core.common.api.BadParamException;
import org.objectweb.util.explorer.core.common.api.Description;
import org.objectweb.util.explorer.core.common.lib.ClassesInheritance;
import org.objectweb.util.explorer.core.panel.api.PanelDescription;
import org.objectweb.util.explorer.core.panel.lib.BasicCompositePanelDescription;
import org.objectweb.util.explorer.resolver.lib.AbstractPropertyResolver;

public class PanelResolver
extends AbstractPropertyResolver {
    protected String getPropertyType() {
        return "panel";
    }

    protected PanelDescription getPanelDesc(Object key) {
        return (PanelDescription)this.getPropertyProvider().getPropertyDescription(this.getPropertyType(), key);
    }

    protected Description getPanelDescription(Entry currentEntry) {
        PanelDescription desc = null;
        if (currentEntry != null && currentEntry.getValue() != null) {
            Class[] javaTypes = ClassesInheritance.getInheritedClasses(currentEntry.getValue().getClass());
            String[] roleIds = this.getRoleProvider().getInheritedRoleIds(this.getRoleManager().getCurrentRoleIds());
            for (int i = 0; i < javaTypes.length; ++i) {
                for (int j = 0; j < roleIds.length; ++j) {
                    Object key = null;
                    try {
                        key = this.getKeyProvider().computeKey(new String[]{this.getTypeSystemId(), javaTypes[i].getName(), roleIds[j]});
                    }
                    catch (BadParamException e) {
                        this.getTrace().warn("Bad key param: " + e.getMessage());
                    }
                    if (key == null) continue;
                    PanelDescription newPanelDesc = this.getPanelDesc(key);
                    if (newPanelDesc != null) {
                        if (desc == null) {
                            desc = new BasicCompositePanelDescription();
                        }
                        desc.addPanelDescription(newPanelDesc);
                    }
                    if (newPanelDesc != null) break;
                }
                if (desc != null && !desc.inheritTypePanel()) break;
            }
        }
        return desc;
    }

    public Description resolve(String propertyType, Entry currentEntry, Entry parentEntry) {
        return this.getPanelDescription(currentEntry);
    }
}

